/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AlarmBlockEntity
extends CustomizableBlockEntity {
    private Option.IntOption range;
    private Option.IntOption delay;
    private int cooldown;
    private boolean isPowered;

    public AlarmBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeAlarm, pos, state);
        this.range = new Option.IntOption(() -> ((AlarmBlockEntity)this).m_58899_(), "range", 17, 0, (Integer)ConfigHandler.SERVER.maxAlarmRange.get(), 1, true);
        this.delay = new Option.IntOption(() -> ((AlarmBlockEntity)this).m_58899_(), "delay", 2, 1, 30, 1, true);
        this.cooldown = 0;
        this.isPowered = false;
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        if (this.isPowered && --this.cooldown == 0) {
            for (ServerPlayer player : ((ServerLevel)world).m_8795_(p -> p.m_142538_().m_123331_((Vec3i)pos) <= Math.pow(((Integer)this.range.get()).intValue(), 2.0))) {
                player.m_6330_(SCSounds.ALARM.event, SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            this.setCooldown((Integer)this.delay.get() * 20);
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128379_("isPowered", this.isPowered);
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.isPowered = tag.m_128471_("isPowered");
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.delay};
    }
}

