/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ClaymoreBlockEntity
extends CustomizableBlockEntity {
    private Option.IntOption range = new Option.IntOption(() -> ((ClaymoreBlockEntity)this).m_58899_(), "range", 5, 1, 10, 1, true);
    private double entityX = -1.0;
    private double entityY = -1.0;
    private double entityZ = -1.0;
    private int cooldown = -1;

    public ClaymoreBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeClaymore, pos, state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        if (this.cooldown-- > 0) {
            return;
        }
        if (this.cooldown == 0) {
            ((ClaymoreBlock)state.m_60734_()).explode(world, pos);
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)ClaymoreBlock.FACING);
        AABB area = new AABB(pos);
        if (dir == Direction.NORTH) {
            area = area.m_82310_(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
        } else if (dir == Direction.SOUTH) {
            area = area.m_82310_(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
        } else if (dir == Direction.EAST) {
            area = area.m_82310_((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
        } else if (dir == Direction.WEST) {
            area = area.m_82310_((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
        }
        List entities = world.m_6443_(LivingEntity.class, area, e -> !EntityUtils.isInvisible(e));
        for (LivingEntity entity : entities) {
            if (PlayerUtils.isPlayerMountedOnCamera(entity) || EntityUtils.doesEntityOwn((Entity)entity, world, pos)) continue;
            this.entityX = entity.m_20185_();
            this.entityY = entity.m_20186_();
            this.entityZ = entity.m_20189_();
            this.cooldown = 20;
            world.m_5594_(null, new BlockPos((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
            break;
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.writeOptions(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128347_("entityX", this.entityX);
        tag.m_128347_("entityY", this.entityY);
        tag.m_128347_("entityZ", this.entityZ);
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readOptions(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.entityX = tag.m_128459_("entityX");
        this.entityY = tag.m_128459_("entityY");
        this.entityZ = tag.m_128459_("entityZ");
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }
}

