/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class DisguisableBlockEntity
extends CustomizableBlockEntity {
    private boolean firstTick = true;

    public DisguisableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        super.tick(world, pos, state);
        if (world.f_46443_ && this.firstTick) {
            this.firstTick = false;
            ClientHandler.refreshModelData(this);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (!this.f_58857_.f_46443_ && module == ModuleType.DISGUISE) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_BLOCK_RL, (Object)this.m_58900_().m_60734_().getRegistryName()).build();
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ClientHandler.refreshModelData(this);
        }
    }
}

