/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryScannerBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider {
    private Option.BooleanOption horizontal = new Option.BooleanOption("horizontal", false);
    private Option.BooleanOption solidifyField = new Option.BooleanOption("solidifyField", false);
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> new EmptyHandler());
    private NonNullList<ItemStack> inventoryContents = NonNullList.m_122780_((int)37, (Object)ItemStack.f_41583_);
    private boolean isProvidingPower;
    private int cooldown;

    public InventoryScannerBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeInventoryScanner, pos, state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        super.tick(world, pos, state);
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(world, pos, state.m_60734_(), 1, true);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag list = tag.m_128437_("Items", 10);
        this.inventoryContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            int slot = stackTag.m_128445_("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.m_41712_((CompoundTag)stackTag));
        }
        this.cooldown = tag.m_128451_("cooldown");
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).m_41739_(stackTag);
            list.add((Object)stackTag);
        }
        tag.m_128365_("Items", (Tag)list);
        tag.m_128405_("cooldown", this.cooldown);
        return tag;
    }

    public int m_6643_() {
        return 37;
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).m_41619_()) {
            if (((ItemStack)this.inventoryContents.get(index)).m_41613_() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).m_41620_(count);
            if (((ItemStack)this.inventoryContents.get(index)).m_41613_() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.f_41583_);
            }
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).m_41619_(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.m_41619_() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.getStackInSlot(slot);
        int limit = stackToInsert.m_41720_().getItemStackLimit(stackToInsert);
        if (slotStack.m_41619_()) {
            this.m_6836_(slot, stackToInsert);
            return ItemStack.f_41583_;
        }
        if (InventoryScannerFieldBlock.areItemStacksEqual(slotStack, stackToInsert) && slotStack.m_41613_() < limit) {
            if (limit - slotStack.m_41613_() >= stackToInsert.m_41613_()) {
                slotStack.m_41764_(slotStack.m_41613_() + stackToInsert.m_41613_());
                return ItemStack.f_41583_;
            }
            ItemStack toInsert = stackToInsert.m_41777_();
            ItemStack toReturn = toInsert.m_41620_(slotStack.m_41613_() + stackToInsert.m_41613_() - limit);
            slotStack.m_41764_(slotStack.m_41613_() + toInsert.m_41613_());
            return toReturn;
        }
        return stackToInsert;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return EMPTY_INVENTORY.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean hasCustomSCName() {
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int var1, ItemStack var2) {
        return true;
    }

    public boolean shouldProvidePower() {
        return this.hasModule(ModuleType.REDSTONE) && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
        if (connectedScanner != null && !connectedScanner.hasModule(module)) {
            connectedScanner.insertModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
        if (connectedScanner != null && connectedScanner.hasModule(module)) {
            connectedScanner.removeModule(module);
        }
        if (module == ModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.m_6643_(); ++i) {
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 0; i < connectedScanner.getContents().size(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.f_41583_);
                }
            }
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.STORAGE, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("horizontal")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
            if (connectedScanner != null) {
                Direction facing = (Direction)this.m_58900_().m_61143_((Property)InventoryScannerBlock.FACING);
                for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                    BlockPos offsetPos = this.f_58858_.m_5484_(facing, i);
                    BlockState state = this.f_58857_.m_8055_(offsetPos);
                    Block block = state.m_60734_();
                    if (block == SCContent.INVENTORY_SCANNER_FIELD.get()) {
                        this.f_58857_.m_46597_(offsetPos, (BlockState)state.m_61124_((Property)InventoryScannerFieldBlock.HORIZONTAL, (Comparable)((Boolean)bo.get())));
                        continue;
                    }
                    if (!state.m_60795_() && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get() || block == SCContent.INVENTORY_SCANNER.get() && state.m_61143_((Property)InventoryScannerBlock.FACING) == facing.m_122424_()) break;
                }
                connectedScanner.setHorizontal((Boolean)bo.get());
            }
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)((Boolean)bo.get())));
        } else if (option.getName().equals("solidifyField")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
            connectedScanner.setSolidifyField((Boolean)bo.get());
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal.setValue(isHorizontal);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        this.solidifyField.setValue(shouldSolidify);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField};
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new InventoryScannerMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return new TranslatableComponent(((Block)SCContent.INVENTORY_SCANNER.get()).m_7705_());
    }

    public void m_6211_() {
        this.inventoryContents.clear();
    }

    public boolean m_7983_() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack m_8016_(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }
}

