/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class KeypadBlockEntity
extends DisguisableBlockEntity
implements IPasswordProtected {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            KeypadBlockEntity.this.f_58857_.m_46597_(KeypadBlockEntity.this.f_58858_, (BlockState)KeypadBlockEntity.this.m_58900_().m_61124_((Property)KeypadBlock.POWERED, (Comparable)((Boolean)this.get())));
            KeypadBlockEntity.this.f_58857_.m_46672_(KeypadBlockEntity.this.f_58858_, (Block)SCContent.KEYPAD.get());
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeypadBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);

    public KeypadBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeKeypad, pos, state);
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    @Override
    public void activate(Player player) {
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof KeypadBlock) {
            KeypadBlock.activate(this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (this.getPassword() != null) {
            Player player2 = player;
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeCheckPassword, windowId, KeypadBlockEntity.this.f_58857_, KeypadBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else if (this.getOwner().isOwner(player)) {
            Player player3 = player;
            if (player3 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player3;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeSetPassword, windowId, KeypadBlockEntity.this.f_58857_, KeypadBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        if (!((Boolean)state.m_61143_((Property)KeypadBlock.POWERED)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

