/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeypadChestBlockEntity
extends ChestBlockEntity
implements IPasswordProtected,
IOwnable,
IModuleInventory,
ICustomizable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private String passcode;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public KeypadChestBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeKeypadChest, pos, state);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        if (this.owner != null) {
            tag.m_128359_("owner", this.owner.getName());
            tag.m_128359_("ownerUUID", this.owner.getUUID());
        }
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.passcode = tag.m_128461_("passcode");
        this.owner.setOwnerName(tag.m_128461_("owner"));
        this.owner.setOwnerUUID(tag.m_128461_("ownerUUID"));
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public Component m_6820_() {
        return Utils.localize("block.securitycraft.keypad_chest", new Object[0]);
    }

    protected void m_142151_(Level level, BlockPos pos, BlockState state, int i, int j) {
        super.m_142151_(level, pos, state, i, j);
        if (this.hasModule(ModuleType.REDSTONE)) {
            level.m_46672_(pos, state.m_60734_());
            level.m_46672_(this.f_58858_.m_7495_(), state.m_60734_());
        }
    }

    public int getNumPlayersUsing() {
        return this.f_155324_.m_155450_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    public LazyOptional<IItemHandler> getHandlerForSentry(Sentry entity) {
        if (entity.getOwner().owns(this)) {
            return super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.m_8020_(slot);
    }

    @Override
    public void activate(Player player) {
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof KeypadChestBlock && !this.isBlocked()) {
            KeypadChestBlock.activate(this.f_58857_, this.f_58858_, player);
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (this.isBlocked()) {
            return;
        }
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeCheckPassword, windowId, KeypadChestBlockEntity.this.f_58857_, KeypadChestBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_CHEST.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeSetPassword, windowId, KeypadChestBlockEntity.this.f_58857_, KeypadChestBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_CHEST.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, Player player) {
        this.activate(player);
        return true;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        this.addOrRemoveModuleFromAttached(stack, false);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        this.addOrRemoveModuleFromAttached(stack, true);
    }

    @Override
    public void onOptionChanged(Option<?> o) {
        Option<?> option = o;
        if (option instanceof Option.BooleanOption) {
            Option.BooleanOption option2 = (Option.BooleanOption)option;
            KeypadChestBlockEntity offsetTe = this.findOther();
            if (offsetTe != null) {
                offsetTe.setSendsMessages((Boolean)option2.get());
            }
        }
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove) {
        Item item;
        if (module.m_41619_() || !((item = module.m_41720_()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        KeypadChestBlockEntity offsetTe = this.findOther();
        if (offsetTe != null) {
            if (remove) {
                offsetTe.removeModule(moduleItem.getModuleType());
            } else {
                offsetTe.insertModule(module);
            }
        }
    }

    public KeypadChestBlockEntity findOther() {
        BlockState state = this.m_58900_();
        ChestType type = (ChestType)state.m_61143_((Property)KeypadChestBlock.f_51479_);
        if (type != ChestType.SINGLE) {
            BlockEntity offsetTe;
            BlockEntity blockEntity;
            ChestType offsetType;
            BlockPos offsetPos = this.f_58858_.m_142300_(ChestBlock.m_51584_((BlockState)state));
            BlockState offsetState = this.f_58857_.m_8055_(offsetPos);
            if (state.m_60734_() == offsetState.m_60734_() && (offsetType = (ChestType)offsetState.m_61143_((Property)KeypadChestBlock.f_51479_)) != ChestType.SINGLE && type != offsetType && state.m_61143_((Property)KeypadChestBlock.f_51478_) == offsetState.m_61143_((Property)KeypadChestBlock.f_51478_) && (blockEntity = (offsetTe = this.f_58857_.m_7702_(offsetPos))) instanceof KeypadChestBlockEntity) {
                KeypadChestBlockEntity te = (KeypadChestBlockEntity)blockEntity;
                return te;
            }
        }
        return null;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public boolean isBlocked() {
        for (Direction dir : Direction.Plane.HORIZONTAL.m_122557_().collect(Collectors.toList())) {
            BlockPos pos = this.m_58899_().m_142300_(dir);
            if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof KeypadChestBlock) || !KeypadChestBlock.isBlocked(this.f_58857_, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return KeypadChestBlock.isBlocked(this.m_58904_(), this.m_58899_());
    }

    @Override
    public BlockEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public void setSendsMessages(boolean value) {
        this.sendMessage.setValue(value);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }
}

