/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasswordProtected {
    private String passcode;

    public KeypadDoorBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeKeypadDoor, pos, state);
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    @Override
    public void activate(Player player) {
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof KeypadDoorBlock) {
            KeypadDoorBlock.activate(this.f_58857_, this.f_58858_, this.m_58900_(), this.getSignalLength());
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (this.getPassword() != null) {
            Player player2 = player;
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeCheckPassword, windowId, KeypadDoorBlockEntity.this.f_58857_, KeypadDoorBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_DOOR.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else if (this.getOwner().isOwner(player)) {
            Player player3 = player;
            if (player3 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player3;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeSetPassword, windowId, KeypadDoorBlockEntity.this.f_58857_, KeypadDoorBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_DOOR.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, Player player) {
        if (!((Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        BlockEntity te = null;
        this.passcode = password;
        if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            te = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        } else if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            te = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        BlockEntity blockEntity = te;
        if (blockEntity instanceof KeypadDoorBlockEntity) {
            KeypadDoorBlockEntity doorTe = (KeypadDoorBlockEntity)blockEntity;
            doorTe.setPasswordExclusively(password);
        }
    }

    public void setPasswordExclusively(String password) {
        this.passcode = password;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }
}

