/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.KeypadFurnaceMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeypadFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IPasswordProtected,
MenuProvider,
IOwnable,
INameable,
IModuleInventory,
ICustomizable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private Component furnaceCustomName;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public KeypadFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeKeypadFurnace, pos, state, RecipeType.f_44108_);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            tag.m_128359_("owner", this.owner.getName());
            tag.m_128359_("ownerUUID", this.owner.getUUID());
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        if (this.hasCustomSCName()) {
            tag.m_128359_("CustomName", this.furnaceCustomName.getString());
        }
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        this.owner.setOwnerName(tag.m_128461_("owner"));
        this.owner.setOwnerUUID(tag.m_128461_("ownerUUID"));
        this.passcode = tag.m_128461_("passcode");
        this.furnaceCustomName = new TextComponent(tag.m_128461_("CustomName"));
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.f_58310_.get(slot);
    }

    @Override
    public void activate(Player player) {
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof KeypadFurnaceBlock) {
            KeypadFurnaceBlock.activate(this.f_58857_, this.f_58858_, player);
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (this.getPassword() != null) {
            Player player2 = player;
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeCheckPassword, windowId, KeypadFurnaceBlockEntity.this.f_58857_, KeypadFurnaceBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_FURNACE.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else if (this.getOwner().isOwner(player)) {
            Player player3 = player;
            if (player3 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player3;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new GenericTEMenu(SCContent.mTypeSetPassword, windowId, KeypadFurnaceBlockEntity.this.f_58857_, KeypadFurnaceBlockEntity.this.f_58858_);
                    }

                    public Component m_5446_() {
                        return new TranslatableComponent(((Block)SCContent.KEYPAD_FURNACE.get()).m_7705_());
                    }
                }, (BlockPos)this.f_58858_);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        this.activate(player);
        return true;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public ContainerData getFurnaceData() {
        return this.f_58311_;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new KeypadFurnaceMenu(windowId, this.f_58857_, this.f_58858_, inv, (Container)this, this.f_58311_);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return this.m_7208_(windowId, inv, inv.f_35978_);
    }

    public Component m_5446_() {
        return this.hasCustomSCName() ? this.getCustomSCName() : this.m_6820_();
    }

    protected Component m_6820_() {
        return new TranslatableComponent(((Block)SCContent.KEYPAD_FURNACE.get()).m_7705_());
    }

    @Override
    public Component getCustomSCName() {
        return this.furnaceCustomName;
    }

    @Override
    public void setCustomSCName(Component customName) {
        this.furnaceCustomName = customName;
    }

    @Override
    public boolean hasCustomSCName() {
        return this.furnaceCustomName != null && this.furnaceCustomName.getString() != null && !this.furnaceCustomName.getString().isEmpty();
    }

    @Override
    public boolean canBeNamed() {
        return true;
    }

    @Override
    public BlockEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

