/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class LaserBlockBlockEntity
extends DisguisableBlockEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeLaserBlock, pos, state);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableBlockEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

