/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    public static final int RENDER_DISTANCE = 100;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    public boolean activatedByRedstone = false;
    public boolean active = false;
    private boolean horizontal = false;
    private ItemStack projectedBlock = ItemStack.f_41583_;

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeProjector, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(100.0);
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        tag.m_128405_("width", this.projectionWidth);
        tag.m_128405_("height", this.projectionHeight);
        tag.m_128405_("range", this.projectionRange);
        tag.m_128405_("offset", this.projectionOffset);
        tag.m_128379_("active", this.active);
        tag.m_128379_("horizontal", this.horizontal);
        tag.m_128365_("storedItem", (Tag)this.projectedBlock.m_41739_(new CompoundTag()));
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.projectionWidth = tag.m_128451_("width");
        this.projectionHeight = tag.m_128451_("height");
        this.projectionRange = tag.m_128451_("range");
        this.projectionOffset = tag.m_128451_("offset");
        this.activatedByRedstone = this.hasModule(ModuleType.REDSTONE);
        this.active = tag.m_128471_("active");
        this.horizontal = tag.m_128471_("horizontal");
        this.projectedBlock = ItemStack.m_41712_((CompoundTag)tag.m_128469_("storedItem"));
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public boolean isActive() {
        return this.activatedByRedstone ? this.active : true;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
    }

    public Block getProjectedBlock() {
        return Block.m_49814_((Item)this.projectedBlock.m_41720_());
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ProjectorMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return new TranslatableComponent(((Block)SCContent.PROJECTOR.get()).m_7705_());
    }

    public void m_6211_() {
        this.projectedBlock = ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.f_41583_;
        }
        return stack;
    }

    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.f_41583_);
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    public boolean m_7983_() {
        return this.projectedBlock.m_41619_();
    }

    public boolean m_6542_(Player arg0) {
        return true;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.f_41583_;
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack = new ItemStack((ItemLike)stack.m_41720_(), this.m_6893_());
        }
        this.projectedBlock = stack;
    }

    @Override
    public boolean enableHack() {
        return true;
    }
}

