/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class RetinalScannerBlockEntity
extends DisguisableBlockEntity {
    private Option.BooleanOption activatedByEntities = new Option.BooleanOption("activatedByEntities", false);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((RetinalScannerBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    private GameProfile ownerProfile;
    private static GameProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private static Executor mainThreadExecutor;

    public RetinalScannerBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeRetinalScanner, pos, state);
    }

    @Override
    public void entityViewed(LivingEntity entity) {
        BlockState state;
        if (!(this.f_58857_.f_46443_ || ((Boolean)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)RetinalScannerBlock.POWERED)).booleanValue() || EntityUtils.isInvisible(entity))) {
            Player player;
            if (!(entity instanceof Player) && !((Boolean)this.activatedByEntities.get()).booleanValue()) {
                return;
            }
            if (entity instanceof Player && PlayerUtils.isPlayerMountedOnCamera(entity)) {
                return;
            }
            LivingEntity livingEntity = entity;
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (!this.getOwner().isOwner(player) && !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)entity)) {
                    PlayerUtils.sendMessageToPlayer((Player)entity, (MutableComponent)Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", this.getOwner().getName()), ChatFormatting.RED);
                    return;
                }
            }
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)RetinalScannerBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.f_58857_.m_6219_().m_5945_(new BlockPos((Vec3i)this.f_58858_), (Object)((Block)SCContent.RETINAL_SCANNER.get()), this.getSignalLength());
            livingEntity = entity;
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.RETINAL_SCANNER.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", entity.m_7755_()), ChatFormatting.GREEN);
                }
            }
        }
    }

    @Override
    public int getViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength};
    }

    public static void setProfileCache(GameProfileCache profileCacheIn) {
        profileCache = profileCacheIn;
    }

    public static void setSessionService(MinecraftSessionService sessionServiceIn) {
        sessionService = sessionServiceIn;
    }

    public static void setMainThreadExecutor(Executor mainThreadExecutorIn) {
        mainThreadExecutor = mainThreadExecutorIn;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        if (!StringUtil.m_14408_((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner") && this.ownerProfile != null) {
            CompoundTag ownerProfileTag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)ownerProfileTag, (GameProfile)this.ownerProfile);
            tag.m_128365_("ownerProfile", (Tag)ownerProfileTag);
        }
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("ownerProfile", 10)) {
            this.setPlayerProfile(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("ownerProfile")));
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level world, BlockPos pos) {
        super.onOwnerChanged(state, world, pos);
        this.setPlayerProfile(new GameProfile(null, this.getOwner().getName()));
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerProfile(@Nullable GameProfile profile) {
        RetinalScannerBlockEntity retinalScannerBlockEntity = this;
        synchronized (retinalScannerBlockEntity) {
            this.ownerProfile = profile;
        }
        this.updatePlayerProfile();
    }

    public void updatePlayerProfile() {
        if (profileCache == null && ServerLifecycleHooks.getCurrentServer() != null) {
            RetinalScannerBlockEntity.setProfileCache(ServerLifecycleHooks.getCurrentServer().m_129927_());
        }
        if (sessionService == null && ServerLifecycleHooks.getCurrentServer() != null) {
            RetinalScannerBlockEntity.setSessionService(ServerLifecycleHooks.getCurrentServer().m_129925_());
        }
        if (mainThreadExecutor == null && ServerLifecycleHooks.getCurrentServer() != null) {
            RetinalScannerBlockEntity.setMainThreadExecutor((Executor)ServerLifecycleHooks.getCurrentServer());
        }
        this.updateGameProfile(this.ownerProfile, profile -> {
            this.ownerProfile = profile;
            this.m_6596_();
        });
    }

    private void updateGameProfile(GameProfile input, Consumer<GameProfile> onChanged) {
        if (!(!((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() || input == null || StringUtil.m_14408_((String)input.getName()) || input.isComplete() && input.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.m_143967_(input.getName(), result -> Util.m_137578_().execute(() -> Util.m_137521_((Optional)result, gameProfile -> {
                com.mojang.authlib.properties.Property textures = (com.mojang.authlib.properties.Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                if (textures == null) {
                    gameProfile = sessionService.fillProfileProperties(gameProfile, true);
                }
                GameProfile profile = gameProfile;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(profile);
                    onChanged.accept(profile);
                });
            }, () -> mainThreadExecutor.execute(() -> onChanged.accept(input)))));
        } else {
            onChanged.accept(input);
        }
    }
}

