/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ScannerDoorBlockEntity
extends SpecialDoorBlockEntity {
    public ScannerDoorBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeScannerDoor, pos, state);
    }

    @Override
    public void entityViewed(LivingEntity entity) {
        BlockState upperState = this.f_58857_.m_8055_(this.f_58858_);
        BlockState lowerState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (!this.f_58857_.f_46443_ && upperState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER && !EntityUtils.isInvisible(entity)) {
            LivingEntity livingEntity = entity;
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
                return;
            }
            if (!this.getOwner().isOwner(player) && !ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", this.getOwner().getName()), ChatFormatting.RED);
                return;
            }
            boolean open = (Boolean)lowerState.m_61143_((Property)DoorBlock.f_52727_) == false;
            int length = this.getSignalLength();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)upperState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)upperState.m_61143_((Property)DoorBlock.f_52727_) == false)), 3);
            this.f_58857_.m_7731_(this.f_58858_.m_7495_(), (BlockState)lowerState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)lowerState.m_61143_((Property)DoorBlock.f_52727_) == false)), 3);
            this.f_58857_.m_5898_(null, open ? 1005 : 1011, this.f_58858_, 0);
            if (open && length > 0) {
                this.f_58857_.m_6219_().m_5945_(this.f_58858_, (Object)((Block)SCContent.SCANNER_DOOR.get()), length);
            }
            if (open && this.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", player.m_7755_()), ChatFormatting.GREEN);
            }
        }
    }

    @Override
    public int getViewCooldown() {
        return 30;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 0;
    }
}

