/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.ClearLoggerClient;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class UsernameLoggerBlockEntity
extends DisguisableBlockEntity
implements MenuProvider {
    private Option.IntOption searchRadius = new Option.IntOption(() -> ((UsernameLoggerBlockEntity)this).m_58899_(), "searchRadius", 3, 1, 20, 1, true);
    public String[] players = new String[100];
    public String[] uuids = new String[100];
    public long[] timestamps = new long[100];

    public UsernameLoggerBlockEntity(BlockPos pos, BlockState state) {
        super(SCContent.beTypeUsernameLogger, pos, state);
    }

    @Override
    public boolean attackEntity(Entity entity) {
        Entity entity2;
        if (!this.f_58857_.f_46443_ && (entity2 = entity) instanceof Player) {
            Player player = (Player)entity2;
            this.addPlayer(player);
            this.sendChangeToClient(false);
        }
        return true;
    }

    @Override
    public boolean canAttack() {
        return this.f_58857_.m_46755_(this.f_58858_) > 0;
    }

    public void logPlayers() {
        int range = (Integer)this.searchRadius.get();
        AABB area = new AABB(this.f_58858_).m_82400_((double)range);
        List entities = this.f_58857_.m_45976_(Player.class, area);
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            this.addPlayer((Player)iterator.next());
        }
        this.sendChangeToClient(false);
    }

    private void addPlayer(Player player) {
        String playerName = player.m_7755_().getString();
        long timestamp = System.currentTimeMillis();
        if (!(this.getOwner().isOwner(player) || EntityUtils.isInvisible((LivingEntity)player) || this.hasPlayerName(playerName, timestamp))) {
            if (ModuleUtils.isAllowed((IModuleInventory)this, (Entity)player)) {
                return;
            }
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] != null && !this.players[i].equals("")) continue;
                this.players[i] = player.m_7755_().getString();
                this.uuids[i] = player.m_36316_().getId().toString();
                this.timestamps[i] = timestamp;
                break;
            }
        }
    }

    private boolean hasPlayerName(String username, long timestamp) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.players[i].equals(username) || this.timestamps[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        for (int i = 0; i < this.players.length; ++i) {
            tag.m_128359_("player" + i, this.players[i] == null ? "" : this.players[i]);
            tag.m_128359_("uuid" + i, this.uuids[i] == null ? "" : this.uuids[i]);
            tag.m_128356_("timestamp" + i, this.timestamps[i]);
        }
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (int i = 0; i < this.players.length; ++i) {
            this.players[i] = tag.m_128461_("player" + i);
            this.uuids[i] = tag.m_128461_("uuid" + i);
            this.timestamps[i] = tag.m_128454_("timestamp" + i);
        }
    }

    public void sendChangeToClient(boolean clear) {
        if (!clear) {
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] == null) continue;
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateLogger(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), i, this.players[i], this.uuids[i], this.timestamps[i]));
            }
        } else {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new ClearLoggerClient(this.f_58858_));
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new GenericTEMenu(SCContent.mTypeUsernameLogger, windowId, this.f_58857_, this.f_58858_);
    }

    public Component m_5446_() {
        return new TranslatableComponent(((Block)SCContent.USERNAME_LOGGER.get()).m_7705_());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius};
    }
}

