/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AlarmBlock
extends OwnableBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public AlarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return facing == Direction.UP && BlockUtils.isSideSolid(world, pos.m_7495_(), Direction.UP) ? true : BlockUtils.isSideSolid(world, pos.m_142300_(facing.m_122424_()), facing);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return BlockUtils.isSideSolid((LevelReader)world, pos.m_142300_(facing.m_122424_()), facing) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing) : null;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean flag) {
        if (!world.f_46443_) {
            world.m_6219_().m_5945_(pos, (Object)state.m_60734_(), 5);
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.f_46443_) {
            this.playSoundAndUpdate((Level)world, pos);
            world.m_6219_().m_5945_(pos, (Object)state.m_60734_(), 5);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader w, BlockPos pos, BlockPos neighbor) {
        LevelReader levelReader;
        if (w.m_5776_() || !((levelReader = w) instanceof Level)) {
            return;
        }
        Level world = (Level)levelReader;
        this.playSoundAndUpdate(world, pos);
        Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        if (!BlockUtils.isSideSolid((LevelReader)world, pos.m_142300_(facing.m_122424_()), facing)) {
            world.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> Shapes.m_83144_();
        };
    }

    private void playSoundAndUpdate(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != SCContent.ALARM.get()) {
            return;
        }
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity te = (AlarmBlockEntity)blockEntity;
            if (world.m_46755_(pos) > 0) {
                boolean isPowered = te.isPowered();
                if (!isPowered) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    te.setPowered(true);
                }
            } else {
                boolean isPowered = te.isPowered();
                if (isPowered) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    te.setPowered(false);
                }
            }
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((Block)SCContent.ALARM.get()).m_5456_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{LIT});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AlarmBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? null : AlarmBlock.m_152132_(type, SCContent.beTypeAlarm, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            case FRONT_BACK: {
                if (facing.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
        }
        return state;
    }
}

