/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedIronBarsBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPaneBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;

public class CageTrapBlock
extends DisguisableBlock
implements IIntersectable {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");

    public CageTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof CageTrapBlockEntity) {
            EntityCollisionContext ctx;
            CageTrapBlockEntity te = (CageTrapBlockEntity)blockEntity;
            CollisionContext collisionContext2 = collisionContext;
            if (collisionContext2 instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext2).m_166012_().isPresent()) {
                Entity entity = (Entity)ctx.m_166012_().get();
                Entity entity2 = entity;
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                        return this.getCorrectShape(state, world, pos, collisionContext, te);
                    }
                }
                if (entity instanceof Mob && !((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    return te.capturesMobs() ? Shapes.m_83040_() : this.getCorrectShape(state, world, pos, collisionContext, te);
                }
                if (entity instanceof ItemEntity) {
                    return this.getCorrectShape(state, world, pos, collisionContext, te);
                }
            }
            return (Boolean)state.m_61143_((Property)DEACTIVATED) != false ? this.getCorrectShape(state, world, pos, collisionContext, te) : Shapes.m_83040_();
        }
        return Shapes.m_83040_();
    }

    private VoxelShape getCorrectShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx, DisguisableBlockEntity disguisableTe) {
        ItemStack moduleStack = disguisableTe.getModule(ModuleType.DISGUISE);
        if (!moduleStack.m_41619_() && ((ModuleItem)moduleStack.m_41720_()).getBlockAddons(moduleStack.m_41783_()).size() > 0) {
            return super.m_5939_(state, world, pos, ctx);
        }
        return Shapes.m_83144_();
    }

    @Override
    public void onEntityIntersected(Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_) {
            CageTrapBlockEntity tile = (CageTrapBlockEntity)world.m_7702_(pos);
            boolean isPlayer = entity instanceof Player;
            if (isPlayer || entity instanceof Mob && tile.capturesMobs()) {
                if (isPlayer && tile.getOwner().isOwner((Player)entity)) {
                    return;
                }
                BlockState state = world.m_8055_(pos);
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    return;
                }
                BlockPos topMiddle = pos.m_6630_(4);
                String ownerName = tile.getOwner().getName();
                BlockModifier placer = new BlockModifier(world, new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos), tile.getOwner());
                placer.loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    if (w.m_46859_((BlockPos)p)) {
                        if (p.equals((Object)topMiddle)) {
                            w.m_46597_((BlockPos)p, ((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()).m_49966_());
                        } else {
                            w.m_46597_((BlockPos)p, ((ReinforcedPaneBlock)SCContent.REINFORCED_IRON_BARS.get()).getStateForPlacement((BlockGetter)w, (BlockPos)p));
                        }
                    }
                }));
                placer.loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    BlockEntity ironBarsTe$temp;
                    BlockEntity te = w.m_7702_((BlockPos)p);
                    BlockEntity ownable$temp = te;
                    if (ownable$temp instanceof IOwnable) {
                        IOwnable ownable = (IOwnable)ownable$temp;
                        ownable.setOwner(o.getUUID(), o.getName());
                    }
                    if ((ironBarsTe$temp = te) instanceof ReinforcedIronBarsBlockEntity) {
                        ReinforcedIronBarsBlockEntity ironBarsTe = (ReinforcedIronBarsBlockEntity)ironBarsTe$temp;
                        ironBarsTe.setCanDrop(false);
                    }
                }));
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                world.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 3.0f, 1.0f);
                if (isPlayer && PlayerUtils.isPlayerOnline(ownerName)) {
                    PlayerUtils.sendMessageToPlayer(ownerName, (MutableComponent)Utils.localize(((Block)SCContent.CAGE_TRAP.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cageTrap.captured", ((Player)entity).m_7755_(), Utils.getFormattedCoordinates(pos)), ChatFormatting.BLACK);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == SCContent.WIRE_CUTTERS.get()) {
            if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                world.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_42451_ && ((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player player) {
        return (BlockState)this.m_49966_().m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DEACTIVATED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CageTrapBlockEntity(pos, state).intersectsEntities();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CageTrapBlock.m_152132_(type, SCContent.beTypeCageTrap, WorldUtils::blockEntityTicker);
    }

    public static class BlockModifier {
        private Level world;
        private BlockPos.MutableBlockPos pos;
        private BlockPos origin;
        private Owner owner;

        public BlockModifier(Level world, BlockPos.MutableBlockPos origin, Owner owner) {
            this.world = world;
            this.pos = origin.m_122184_(-1, 1, -1);
            this.origin = origin.m_7949_();
            this.owner = owner;
        }

        public void loop(TriConsumer<Level, BlockPos.MutableBlockPos, Owner> ifTrue) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        if (x != 1 || z != 1 || y == 3) {
                            ifTrue.accept((Object)this.world, (Object)this.pos, (Object)this.owner);
                        }
                        this.pos.m_122184_(0, 0, 1);
                    }
                    this.pos.m_122184_(1, 0, -3);
                }
                this.pos.m_122184_(-3, 1, 0);
            }
            this.pos.m_122190_((Vec3i)this.origin);
        }
    }
}

