/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay {
    public DisguisableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isNormalCube(BlockState state, BlockGetter world, BlockPos pos) {
        DisguisableBlock disguisableBlock;
        BlockState disguisedState;
        Block block = state.m_60734_();
        if (block instanceof DisguisableBlock && (disguisedState = (disguisableBlock = (DisguisableBlock)block).getDisguisedStateOrDefault(state, world, pos)).m_60734_() != state.m_60734_()) {
            return disguisedState.m_60796_(world, pos);
        }
        return state.m_60767_().m_76337_() && state.m_60838_(world, pos);
    }

    public static boolean isSuffocating(BlockState state, BlockGetter world, BlockPos pos) {
        DisguisableBlock disguisableBlock;
        BlockState disguisedState;
        Block block = state.m_60734_();
        if (block instanceof DisguisableBlock && (disguisedState = (disguisableBlock = (DisguisableBlock)block).getDisguisedStateOrDefault(state, world, pos)).m_60734_() != state.m_60734_()) {
            return disguisedState.m_60828_(world, pos);
        }
        return state.m_60767_().m_76334_() && state.m_60838_(world, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, (BlockGetter)world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(world, pos, ctx);
        }
        return super.m_5940_(state, world, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60742_(world, pos, ctx);
        }
        return super.m_5939_(state, world, pos, ctx);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60768_(world, pos);
        }
        return super.m_7952_(state, world, pos);
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(world, pos);
        }
        return super.m_7749_(state, world, pos);
    }

    public final BlockState getDisguisedStateOrDefault(BlockState state, BlockGetter world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public BlockState getDisguisedBlockState(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DisguisableBlockEntity) {
            ItemStack module;
            DisguisableBlockEntity te = (DisguisableBlockEntity)blockEntity;
            ItemStack itemStack = module = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.f_41583_;
            if (!module.m_41619_() && !((ModuleItem)module.m_41720_()).getBlockAddons(module.m_41783_()).isEmpty()) {
                return ((ModuleItem)module.m_41720_()).getBlockAddons(module.m_41783_()).get(0).m_49966_();
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world != null && (blockEntity = world.m_7702_(pos)) instanceof DisguisableBlockEntity) {
            ItemStack disguisedStack;
            ItemStack stack;
            DisguisableBlockEntity te = (DisguisableBlockEntity)blockEntity;
            ItemStack itemStack = stack = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.f_41583_;
            if (!stack.m_41619_() && !((ModuleItem)stack.m_41720_()).getBlockAddons(stack.m_41783_()).isEmpty() && Block.m_49814_((Item)(disguisedStack = ((ModuleItem)stack.m_41720_()).getAddons(stack.m_41783_()).get(0)).m_41720_()) != this) {
                return disguisedStack;
            }
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public ItemStack getDisplayStack(Level world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)world, pos).m_41720_() == this.m_5456_();
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getDisguisedStack(world, pos);
    }
}

