/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class InventoryScannerBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");

    public InventoryScannerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Player player2;
        if (this.isFacingAnotherScanner(world, pos) && (player2 = player) instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            BlockEntity te = world.m_7702_(pos);
            if (!world.f_46443_ && (blockEntity = te) instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)blockEntity;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)menuProvider, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Block)SCContent.INVENTORY_SCANNER.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), ChatFormatting.RED);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        if (world.f_46443_) {
            return;
        }
        this.checkAndPlaceAppropriately(world, pos);
    }

    private void checkAndPlaceAppropriately(Level world, BlockPos pos) {
        Direction facing;
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
        InventoryScannerBlockEntity thisTe = (InventoryScannerBlockEntity)world.m_7702_(pos);
        if (connectedScanner == null || !connectedScanner.getOwner().equals(thisTe.getOwner())) {
            return;
        }
        boolean horizontal = false;
        if (((Boolean)connectedScanner.m_58900_().m_61143_((Property)HORIZONTAL)).booleanValue()) {
            horizontal = true;
        }
        int loopBoundary = (facing = (Direction)world.m_8055_(pos).m_61143_((Property)FACING)) == Direction.WEST || facing == Direction.EAST ? Math.abs(pos.m_123341_() - connectedScanner.m_58899_().m_123341_()) : (facing == Direction.NORTH || facing == Direction.SOUTH ? Math.abs(pos.m_123343_() - connectedScanner.m_58899_().m_123343_()) : 0);
        thisTe.setHorizontal(horizontal);
        for (int i = 1; i < loopBoundary; ++i) {
            if (world.m_8055_(pos.m_5484_(facing, i)).m_60734_() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
            return;
        }
        Option<?>[] customOptions = thisTe.customOptions();
        for (int i = 1; i < loopBoundary; ++i) {
            BlockEntity te;
            BlockPos offsetPos = pos.m_5484_(facing, i);
            world.m_46597_(offsetPos, (BlockState)((BlockState)((Block)SCContent.INVENTORY_SCANNER_FIELD.get()).m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(horizontal)));
            BlockEntity blockEntity = te = world.m_7702_(offsetPos);
            if (!(blockEntity instanceof IOwnable)) continue;
            IOwnable ownable = (IOwnable)blockEntity;
            ownable.setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
        }
        CustomizableBlockEntity.link(thisTe, connectedScanner);
        for (ModuleType type : connectedScanner.getInsertedModules()) {
            thisTe.insertModule(connectedScanner.getModule(type));
        }
        ((Option.BooleanOption)customOptions[0]).setValue(connectedScanner.isHorizontal());
        ((Option.BooleanOption)customOptions[1]).setValue(connectedScanner.doesFieldSolidify());
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world.f_46443_ || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        InventoryScannerBlockEntity connectedScanner = null;
        block0: for (Direction facing : Direction.Plane.HORIZONTAL) {
            for (int i = 1; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                BlockPos offsetIPos = pos.m_5484_(facing, i);
                if (world.m_8055_(offsetIPos).m_60734_() != SCContent.INVENTORY_SCANNER.get()) continue;
                for (int j = 1; j < i; ++j) {
                    BlockPos offsetJPos = pos.m_5484_(facing, j);
                    BlockState field = world.m_8055_(offsetJPos);
                    if (field.m_60734_() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
                    if (facing == Direction.WEST || facing == Direction.EAST) {
                        if (field.m_61143_((Property)InventoryScannerFieldBlock.FACING) != Direction.WEST && field.m_61143_((Property)InventoryScannerFieldBlock.FACING) != Direction.EAST) continue;
                        world.m_46961_(offsetJPos, false);
                        continue;
                    }
                    if (facing != Direction.NORTH && facing != Direction.SOUTH || field.m_61143_((Property)InventoryScannerFieldBlock.FACING) != Direction.NORTH && field.m_61143_((Property)InventoryScannerFieldBlock.FACING) != Direction.SOUTH) continue;
                    world.m_46961_(offsetJPos, false);
                }
                connectedScanner = (InventoryScannerBlockEntity)world.m_7702_(offsetIPos);
                continue block0;
            }
        }
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity i = tile;
        if (i instanceof InventoryScannerBlockEntity) {
            InventoryScannerBlockEntity te = (InventoryScannerBlockEntity)i;
            for (int i2 = 10; i2 < te.m_6643_(); ++i2) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((ItemStack)te.getContents().get(i2)));
            }
        }
        if (connectedScanner != null) {
            for (int i3 = 0; i3 < connectedScanner.getContents().size(); ++i3) {
                connectedScanner.getContents().set(i3, (Object)ItemStack.f_41583_);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private boolean isFacingAnotherScanner(Level world, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(world, pos) != null;
    }

    public static InventoryScannerBlockEntity getConnectedInventoryScanner(Level world, BlockPos pos) {
        Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            BlockPos offsetPos = pos.m_5484_(facing, i);
            BlockState state = world.m_8055_(offsetPos);
            Block block = state.m_60734_();
            if (!state.m_60795_() && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get()) {
                return null;
            }
            if (block != SCContent.INVENTORY_SCANNER.get() || state.m_61143_((Property)FACING) != facing.m_122424_()) continue;
            return (InventoryScannerBlockEntity)world.m_7702_(offsetPos);
        }
        return null;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        this.checkAndPlaceAppropriately((Level)world, pos);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.m_7702_(pos);
        if (!(blockEntity instanceof InventoryScannerBlockEntity)) {
            return 0;
        }
        InventoryScannerBlockEntity te = (InventoryScannerBlockEntity)blockEntity;
        return te.hasModule(ModuleType.REDSTONE) && te.shouldProvidePower() ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.m_6378_(blockState, blockAccess, pos, side);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InventoryScannerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return InventoryScannerBlock.m_152132_(type, SCContent.beTypeInventoryScanner, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class DoorActivator
    implements IDoorActivator {
        private List<Block> blocks = Arrays.asList((Block)SCContent.INVENTORY_SCANNER.get());

        @Override
        public boolean isPowering(Level world, BlockPos pos, BlockState state, BlockEntity te) {
            return ((InventoryScannerBlockEntity)te).hasModule(ModuleType.REDSTONE) && ((InventoryScannerBlockEntity)te).shouldProvidePower();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

