/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.mojang.math.Vector3f;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class KeycardReaderBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KeycardReaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            KeycardReaderBlockEntity te = (KeycardReaderBlockEntity)world.m_7702_(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TranslatableComponent(this.m_7705_()), (MutableComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else {
                boolean isCodebreaker;
                ItemStack stack = player.m_21120_(hand);
                Item item = stack.m_41720_();
                boolean bl = isCodebreaker = item == SCContent.CODEBREAKER.get();
                if (!(item instanceof KeycardItem && stack.m_41782_() && stack.m_41783_().m_128471_("linked") || isCodebreaker)) {
                    if (te.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
                    }
                } else if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    if (isCodebreaker) {
                        if (!player.m_7500_()) {
                            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                        }
                        if (new Random().nextInt(3) == 1) {
                            KeycardReaderBlock.activate(world, pos, te.getSignalLength());
                        }
                    } else {
                        MutableComponent feedback = this.insertCard(world, pos, te, stack, player);
                        if (feedback != null) {
                            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TranslatableComponent(this.m_7705_()), feedback, ChatFormatting.RED);
                        }
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MutableComponent insertCard(Level world, BlockPos pos, KeycardReaderBlockEntity te, ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (!te.getOwner().getUUID().equals(tag.m_128461_("ownerUUID"))) {
            return new TranslatableComponent("messages.securitycraft:keycardReader.differentOwner");
        }
        if (te.getSignature() != tag.m_128451_("signature")) {
            return new TranslatableComponent("messages.securitycraft:keycardReader.wrongSignature");
        }
        int level = ((KeycardItem)stack.m_41720_()).getLevel();
        if (!te.getAcceptedLevels()[level]) {
            return new TranslatableComponent("messages.securitycraft:keycardReader.wrongLevel", new Object[]{level + 1});
        }
        boolean powered = (Boolean)world.m_8055_(pos).m_61143_((Property)POWERED);
        if (tag.m_128471_("limited")) {
            int uses = tag.m_128451_("uses");
            if (uses <= 0) {
                return new TranslatableComponent("messages.securitycraft:keycardReader.noUses");
            }
            if (!player.m_7500_() && !powered) {
                tag.m_128405_("uses", --uses);
            }
        }
        if (!powered) {
            KeycardReaderBlock.activate(world, pos, te.getSignalLength());
        }
        return null;
    }

    public static void activate(Level world, BlockPos pos, int signalLength) {
        world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        world.m_46672_(pos, (Block)SCContent.KEYCARD_READER.get());
        world.m_6219_().m_5945_(pos, (Object)((Block)SCContent.KEYCARD_READER.get()), signalLength);
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.f_46443_) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            world.m_46672_(pos, (Block)SCContent.KEYCARD_READER.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.m_123341_() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.m_123342_() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.m_123343_() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float r = 1.0f;
            float g = Math.max(0.0f, 0.19999999f);
            float b = Math.max(0.0f, -0.099999964f);
            Vector3f vec = new Vector3f(r, g, b);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeycardReaderBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return KeycardReaderBlock.m_152132_(type, SCContent.beTypeKeycardReader, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

