/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class KeypadBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KeypadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        KeypadBlockEntity te = (KeypadBlockEntity)world.m_7702_(pos);
        if (ModuleUtils.isDenied(te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResult.FAIL;
        }
        if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
            if (te.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
            }
            KeypadBlock.activate(world, pos, te.getSignalLength());
        } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand) && !PlayerUtils.isHoldingItem(player, SCContent.KEY_PANEL, hand)) {
            te.openPasswordGUI(player);
        }
        return InteractionResult.SUCCESS;
    }

    public static void activate(Level world, BlockPos pos, int signalLength) {
        world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        world.m_46672_(pos, (Block)SCContent.KEYPAD.get());
        world.m_6219_().m_5945_(pos, (Object)((Block)SCContent.KEYPAD.get()), signalLength);
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        world.m_46672_(pos, (Block)SCContent.KEYPAD.get());
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return KeypadBlock.m_152132_(type, SCContent.beTypeKeypad, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return (Block)SCContent.FRAME.get();
        }

        @Override
        public boolean convert(Player player, Level world, BlockPos pos) {
            world.m_46597_(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)world.m_8055_(pos).m_61143_((Property)FrameBlock.FACING)))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)world.m_7702_(pos)).setOwner(player.m_142081_().toString(), player.m_7755_().getString());
            return true;
        }
    }
}

