/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class KeypadChestBlock
extends ChestBlock {
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> CONTAINER_MERGER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chest1, final ChestBlockEntity chest2) {
            CompoundContainer chestInventory = new CompoundContainer((Container)chest1, (Container)chest2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$chestInventory;
                {
                    this.val$chestInventory = container;
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    if (chest1.m_7525_(player) && chest2.m_7525_(player)) {
                        chest1.m_59640_(inventory.f_35978_);
                        chest2.m_59640_(inventory.f_35978_);
                        return ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)this.val$chestInventory);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (chest1.m_8077_()) {
                        return chest1.m_5446_();
                    }
                    return chest2.m_8077_() ? chest2.m_5446_() : Utils.localize("block.securitycraft.keypad_chest_double", new Object[0]);
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity te) {
            return Optional.of(te);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public KeypadChestBlock(BlockBehaviour.Properties properties) {
        super(properties, () -> SCContent.beTypeKeypadChest);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_ && !KeypadChestBlock.isBlocked(world, pos)) {
            KeypadChestBlockEntity te = (KeypadChestBlockEntity)world.m_7702_(pos);
            if (ModuleUtils.isDenied(te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
                return InteractionResult.FAIL;
            }
            if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                if (te.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(this.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                KeypadChestBlock.activate(world, pos, player);
            } else if (!PlayerUtils.isHoldingItem(player, SCContent.CODEBREAKER, hand)) {
                te.openPasswordGUI(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static void activate(Level world, BlockPos pos, Player player) {
        BlockState state;
        ChestBlock block;
        MenuProvider inamedcontainerprovider;
        if (!world.f_46443_ && (inamedcontainerprovider = (block = (ChestBlock)(state = world.m_8055_(pos)).m_60734_()).m_7246_(state, world, pos)) != null) {
            player.m_5893_(inamedcontainerprovider);
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, player));
            if (state.m_61143_((Property)f_51479_) != ChestType.SINGLE) {
                KeypadChestBlockEntity thisTe = (KeypadChestBlockEntity)world.m_7702_(pos);
                BlockEntity otherTe = world.m_7702_(pos.m_142300_(KeypadChestBlock.m_51584_((BlockState)state)));
                BlockEntity blockEntity = otherTe;
                if (blockEntity instanceof KeypadChestBlockEntity) {
                    KeypadChestBlockEntity te = (KeypadChestBlockEntity)blockEntity;
                    if (thisTe.getOwner().owns(te)) {
                        thisTe.setPassword(te.getPassword());
                    }
                }
            }
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity te = (KeypadChestBlockEntity)blockEntity;
            return te.hasModule(ModuleType.REDSTONE) ? Mth.m_14045_((int)te.getNumPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.m_60746_(world, pos, side) : 0;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity tile;
        super.onNeighborChange(state, world, pos, neighbor);
        BlockEntity blockEntity = tile = world.m_7702_(pos);
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity te = (KeypadChestBlockEntity)blockEntity;
            te.m_155250_(state);
        }
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        return ((Optional)this.m_5641_(state, world, pos, false).m_5649_(CONTAINER_MERGER)).orElse(null);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadChestBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? KeypadChestBlock.m_152132_(type, SCContent.beTypeKeypadChest, ChestBlockEntity::m_155343_) : null;
    }

    public static boolean isBlocked(Level world, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(world, pos);
    }

    private static boolean isBelowSolidBlock(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7494_()).m_60796_((BlockGetter)world, pos.m_7494_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_51478_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_51478_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_51478_)));
    }

    public static class Convertible
    implements IPasswordConvertible {
        @Override
        public Block getOriginalBlock() {
            return Blocks.f_50087_;
        }

        @Override
        public boolean convert(Player player, Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            this.convertChest(player, world, pos, facing, type);
            if (type != ChestType.SINGLE) {
                BlockPos newPos = pos.m_142300_(ChestBlock.m_51584_((BlockState)state));
                BlockState newState = world.m_8055_(newPos);
                Direction newFacing = (Direction)newState.m_61143_((Property)ChestBlock.f_51478_);
                ChestType newType = (ChestType)newState.m_61143_((Property)ChestBlock.f_51479_);
                this.convertChest(player, world, newPos, newFacing, newType);
            }
            return true;
        }

        private void convertChest(Player player, Level world, BlockPos pos, Direction facing, ChestType type) {
            ChestBlockEntity chest = (ChestBlockEntity)world.m_7702_(pos);
            CompoundTag tag = chest.m_6945_(new CompoundTag());
            chest.m_6211_();
            world.m_46597_(pos, (BlockState)((BlockState)((Block)SCContent.KEYPAD_CHEST.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)type));
            ((ChestBlockEntity)world.m_7702_(pos)).m_142466_(tag);
            ((IOwnable)world.m_7702_(pos)).setOwner(player.m_142081_().toString(), player.m_7755_().getString());
        }
    }
}

