/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.mojang.math.Vector3f;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserBlock
extends DisguisableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public LaserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        if (!world.f_46443_) {
            this.setLaser(world, pos);
        }
    }

    public void setLaser(Level world, BlockPos pos) {
        LaserBlockBlockEntity thisTe = (LaserBlockBlockEntity)world.m_7702_(pos);
        block0: for (Direction facing : Direction.values()) {
            int boundType = facing == Direction.UP || facing == Direction.DOWN ? 1 : (facing == Direction.NORTH || facing == Direction.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                BlockPos offsetPos = pos.m_5484_(facing, i);
                BlockState offsetState = world.m_8055_(offsetPos);
                Block offsetBlock = offsetState.m_60734_();
                if (!offsetState.m_60795_() && offsetBlock != SCContent.LASER_BLOCK.get()) continue block0;
                if (offsetBlock != SCContent.LASER_BLOCK.get()) continue;
                LaserBlockBlockEntity thatTe = (LaserBlockBlockEntity)world.m_7702_(offsetPos);
                if (!thisTe.getOwner().equals(thatTe.getOwner())) continue block0;
                CustomizableBlockEntity.link(thisTe, thatTe);
                for (ModuleType type : thatTe.getInsertedModules()) {
                    thisTe.insertModule(thatTe.getModule(type));
                }
                if (!thisTe.isEnabled() || !thatTe.isEnabled()) continue block0;
                for (int j = 1; j < i; ++j) {
                    BlockEntity te;
                    offsetPos = pos.m_5484_(facing, j);
                    if (!world.m_8055_(offsetPos).m_60795_()) continue;
                    world.m_46597_(offsetPos, (BlockState)((Block)SCContent.LASER_FIELD.get()).m_49966_().m_61124_((Property)LaserFieldBlock.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                    BlockEntity blockEntity = te = world.m_7702_(offsetPos);
                    if (!(blockEntity instanceof IOwnable)) continue;
                    IOwnable ownable = (IOwnable)blockEntity;
                    ownable.setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
                }
                continue block0;
            }
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!world.m_5776_()) {
            LaserBlock.destroyAdjacentLasers(world, pos);
        }
    }

    public static void destroyAdjacentLasers(LevelAccessor world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos;
            BlockState state;
            int boundType = facing == Direction.UP || facing == Direction.DOWN ? 1 : (facing == Direction.NORTH || facing == Direction.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get() && (state = world.m_8055_(offsetPos = pos.m_5484_(facing, i))).m_60734_() != SCContent.LASER_BLOCK.get(); ++i) {
                if (state.m_60734_() != SCContent.LASER_FIELD.get() || (Integer)state.m_61143_((Property)LaserFieldBlock.BOUNDTYPE) != boundType) continue;
                world.m_46961_(offsetPos, false);
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.setLaser(world, pos);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.m_123341_() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.m_123342_() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.m_123343_() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float r = 1.0f;
            float g = Math.max(0.0f, 0.19999999f);
            float b = Math.max(0.0f, -0.099999964f);
            Vector3f vec = new Vector3f(r, g, b);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LaserBlockBlockEntity(pos, state).linkable();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.m_152132_(type, SCContent.beTypeLaserBlock, WorldUtils::blockEntityTicker);
    }
}

