/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PanicButtonBlock
extends ButtonBlock
implements EntityBlock {
    private static final VoxelShape FLOOR_NS_POWERED = Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape FLOOR_NS_UNPOWERED = Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
    private static final VoxelShape FLOOR_EW_POWERED = Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape FLOOR_EW_UNPOWERED = Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)2.0, (double)13.0);
    private static final VoxelShape WALL_N_POWERED = Block.m_49796_((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_N_UNPOWERED = Block.m_49796_((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_S_POWERED = Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)1.0);
    private static final VoxelShape WALL_S_UNPOWERED = Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)2.0);
    private static final VoxelShape WALL_E_POWERED = Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_E_UNPOWERED = Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_POWERED = Block.m_49796_((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_UNPOWERED = Block.m_49796_((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape CEILING_NS_POWERED = Block.m_49796_((double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_NS_UNPOWERED = Block.m_49796_((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_EW_POWERED = Block.m_49796_((double)5.0, (double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_EW_UNPOWERED = Block.m_49796_((double)5.0, (double)14.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);

    public PanicButtonBlock(boolean isWooden, BlockBehaviour.Properties properties) {
        super(isWooden, properties);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (Player)placer));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean newPowered = (Boolean)state.m_61143_((Property)f_51045_) == false;
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)f_51045_, (Comparable)Boolean.valueOf(newPowered)));
        this.m_51067_(player, (LevelAccessor)world, pos, newPowered);
        if (state.m_61143_((Property)f_53179_) == AttachFace.WALL) {
            this.notifyNeighbors(world, pos, (Direction)state.m_61143_((Property)f_54117_));
        } else if (state.m_61143_((Property)f_53179_) == AttachFace.CEILING) {
            this.notifyNeighbors(world, pos, Direction.DOWN);
        } else if (state.m_61143_((Property)f_53179_) == AttachFace.FLOOR) {
            this.notifyNeighbors(world, pos, Direction.UP);
        }
        return InteractionResult.SUCCESS;
    }

    private void notifyNeighbors(Level world, BlockPos pos, Direction facing) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_142300_(facing.m_122424_()), (Block)this);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        world.m_46747_(pos);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case AttachFace.FLOOR -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield FLOOR_NS_POWERED;
                        }
                        yield FLOOR_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield FLOOR_EW_POWERED;
                        }
                        yield FLOOR_EW_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_N_POWERED;
                        }
                        yield WALL_N_UNPOWERED;
                    }
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_S_POWERED;
                        }
                        yield WALL_S_UNPOWERED;
                    }
                    case EAST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_E_POWERED;
                        }
                        yield WALL_E_UNPOWERED;
                    }
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_W_POWERED;
                        }
                        yield WALL_W_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield CEILING_NS_POWERED;
                        }
                        yield CEILING_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield CEILING_EW_POWERED;
                        }
                        yield CEILING_EW_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    protected SoundEvent m_5722_(boolean turningOn) {
        return turningOn ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
    }
}

