/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.PortableRadarBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PortableRadarBlock
extends OwnableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)7.0);

    public PortableRadarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> Shapes.m_83144_();
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43719_();
        return BlockUtils.isSideSolid((LevelReader)ctx.m_43725_(), ctx.m_8083_().m_142300_(facing.m_122424_()), facing) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing) : null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return BlockUtils.isSideSolid(world, pos.m_142300_(facing.m_122424_()), facing);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public static void togglePowerOutput(Level world, BlockPos pos, boolean par5) {
        BlockState state = world.m_8055_(pos);
        if (par5 && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateAndNotify(world, pos, (Block)SCContent.PORTABLE_RADAR.get(), 1, false);
        } else if (!par5 && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateAndNotify(world, pos, (Block)SCContent.PORTABLE_RADAR.get(), 1, false);
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue() && ((IModuleInventory)world.m_7702_(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, FACING});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PortableRadarBlockEntity(pos, state).nameable();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.m_152132_(type, SCContent.beTypePortableRadar, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            case FRONT_BACK: {
                if (facing.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
        }
        return state;
    }
}

