/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class ProjectorBlock
extends DisguisableBlock {
    private static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)3.0, (double)5.0, (double)0.9, (double)6.0, (double)8.0, (double)1.9), Block.m_49796_((double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)2.0, (double)8.0, (double)0.5, (double)7.0, (double)9.0, (double)1.0), Block.m_49796_((double)2.0, (double)4.0, (double)0.5, (double)7.0, (double)5.0, (double)1.0), Block.m_49796_((double)6.0, (double)5.0, (double)0.5, (double)7.0, (double)8.0, (double)1.0), Block.m_49796_((double)2.0, (double)5.0, (double)0.5, (double)3.0, (double)8.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)3.0, (double)3.0), Block.m_49796_((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)3.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
    private static final VoxelShape SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)15.0), Block.m_49796_((double)10.0, (double)5.0, (double)14.1, (double)13.0, (double)8.0, (double)15.100000000000001), Block.m_49796_((double)9.0, (double)8.0, (double)15.0, (double)14.0, (double)9.0, (double)15.5), Block.m_49796_((double)9.0, (double)4.0, (double)15.0, (double)14.0, (double)5.0, (double)15.5), Block.m_49796_((double)9.0, (double)5.0, (double)15.0, (double)10.0, (double)8.0, (double)15.5), Block.m_49796_((double)13.0, (double)5.0, (double)15.0, (double)14.0, (double)8.0, (double)15.5), Block.m_49796_((double)14.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)3.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
    private static final VoxelShape WEST = Stream.of(Block.m_49796_((double)0.5, (double)5.0, (double)13.0, (double)1.0, (double)8.0, (double)14.0), Block.m_49796_((double)0.5, (double)5.0, (double)9.0, (double)1.0, (double)8.0, (double)10.0), Block.m_49796_((double)0.5, (double)4.0, (double)9.0, (double)1.0, (double)5.0, (double)14.0), Block.m_49796_((double)0.5, (double)8.0, (double)9.0, (double)1.0, (double)9.0, (double)14.0), Block.m_49796_((double)0.75, (double)5.0, (double)10.0, (double)1.75, (double)8.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)2.0), Block.m_49796_((double)1.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
    private static final VoxelShape EAST = Stream.of(Block.m_49796_((double)15.0, (double)5.0, (double)2.0, (double)15.5, (double)8.0, (double)3.0), Block.m_49796_((double)15.0, (double)5.0, (double)6.0, (double)15.5, (double)8.0, (double)7.0), Block.m_49796_((double)15.0, (double)4.0, (double)2.0, (double)15.5, (double)5.0, (double)7.0), Block.m_49796_((double)15.0, (double)8.0, (double)2.0, (double)15.5, (double)9.0, (double)7.0), Block.m_49796_((double)14.25, (double)5.0, (double)3.0, (double)15.25, (double)8.0, (double)6.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());

    public ProjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(world, pos, ctx);
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SOUTH;
            case Direction.EAST -> WEST;
            case Direction.SOUTH -> NORTH;
            case Direction.WEST -> EAST;
            default -> Shapes.m_83144_();
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (!(blockEntity instanceof ProjectorBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ProjectorBlockEntity te = (ProjectorBlockEntity)blockEntity;
        boolean isOwner = te.getOwner().isOwner(player);
        if (!world.f_46443_ && isOwner) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
        }
        return isOwner ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof ProjectorBlockEntity) {
            ProjectorBlockEntity te = (ProjectorBlockEntity)blockEntity;
            ItemEntity item = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), te.getStackInSlot(36));
            WorldUtils.addScheduledTask((LevelAccessor)world, () -> world.m_7967_((Entity)item));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        ProjectorBlockEntity te;
        BlockEntity tile;
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = (tile = world.m_7702_(pos))) instanceof ProjectorBlockEntity && (te = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            te.setActive(world.m_46753_(pos));
            te.sync();
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        ProjectorBlockEntity te;
        BlockEntity tile;
        BlockEntity blockEntity;
        if (!world.m_46753_(pos) && (blockEntity = (tile = world.m_7702_(pos))) instanceof ProjectorBlockEntity && (te = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            te.setActive(false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ProjectorBlock.m_152132_(type, SCContent.beTypeProjector, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.securitycraft:projector").m_6270_(GRAY_STYLE));
    }
}

