/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Iterator;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.entity.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SecurityCameraBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", facing -> facing != Direction.UP);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83064_((AABB)new AABB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f));
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83064_((AABB)new AABB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83064_((AABB)new AABB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE_DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)7.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)15.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0))))));

    public SecurityCameraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        ((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter access, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_((Property)FACING) == Direction.DOWN ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        world.m_46672_(pos.m_142127_(), state.m_60734_());
        world.m_46672_(pos.m_142128_(), state.m_60734_());
        world.m_46672_(pos.m_142126_(), state.m_60734_());
        world.m_46672_(pos.m_142125_(), state.m_60734_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE;
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ctx.m_43719_() != Direction.UP ? this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_()) : null;
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        Direction iFacing;
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        if (BlockUtils.isSideSolid((LevelReader)world, pos.m_142300_(facing.m_122424_()), facing)) {
            return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return state;
        } while (!BlockUtils.isSideSolid((LevelReader)world, pos.m_142300_((iFacing = (Direction)iterator.next()).m_122424_()), iFacing));
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void mountCamera(Level world, BlockPos pos, int id, Player player) {
        Entity entity = player.m_20202_();
        if (entity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)entity;
            SecurityCamera dummyEntity = new SecurityCamera(world, pos, id, cam);
            WorldUtils.addScheduledTask((LevelAccessor)world, () -> world.m_7967_((Entity)dummyEntity));
            player.m_20329_((Entity)dummyEntity);
            return;
        }
        SecurityCamera dummyEntity = new SecurityCamera(world, pos, id, player);
        WorldUtils.addScheduledTask((LevelAccessor)world, () -> world.m_7967_((Entity)dummyEntity));
        player.m_20329_((Entity)dummyEntity);
        Level level = world;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_142646_().m_142273_().forEach(e -> {
                Mob mob;
                Entity mob$temp = e;
                if (mob$temp instanceof Mob && (mob = (Mob)mob$temp).m_5448_() == player) {
                    mob.m_6710_(null);
                }
            });
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return BlockUtils.isSideSolid(world, pos.m_142300_(facing.m_122424_()), facing);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue() && ((IModuleInventory)world.m_7702_(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue() && ((IModuleInventory)world.m_7702_(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(world.m_8055_(pos), (LevelReader)world, pos) && !this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SecurityCameraBlockEntity(pos, state).nameable();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return SecurityCameraBlock.m_152132_(type, SCContent.beTypeSecurityCamera, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            case FRONT_BACK: {
                if (facing.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
        }
        return state;
    }
}

