/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class SpecialDoorBlock
extends DoorBlock
implements EntityBlock {
    public SpecialDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.onNeighborChanged(world, pos, fromPos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        LivingEntity livingEntity = placer;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, player));
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    public void onNeighborChanged(Level world, BlockPos pos, BlockPos neighbor) {
        BlockState state = world.m_8055_(pos);
        Block neighborBlock = world.m_8055_(neighbor).m_60734_();
        if (state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = pos.m_7495_();
            BlockState stateBelow = world.m_8055_(blockBelow);
            if (stateBelow.m_60734_() != this) {
                world.m_46961_(pos, false);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockBelow = pos.m_7494_();
            BlockState stateBelow = world.m_8055_(blockBelow);
            if (stateBelow.m_60734_() != this) {
                world.m_46961_(pos, false);
                drop = true;
            }
            if (!world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
                world.m_46961_(pos, false);
                drop = true;
                if (stateBelow.m_60734_() == this) {
                    world.m_46961_(blockBelow, false);
                }
            }
            if (drop && !world.f_46443_) {
                world.m_46961_(pos, false);
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getDoorItem()));
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        BlockState lowerState;
        BlockState upperState = world.m_8055_(pos);
        if (upperState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            lowerState = upperState;
            pos = pos.m_7494_();
            upperState = world.m_8055_(pos);
        } else {
            lowerState = world.m_8055_(pos.m_7495_());
        }
        world.m_7731_(pos, (BlockState)upperState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)), 3);
        world.m_7731_(pos.m_7495_(), (BlockState)lowerState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)), 3);
        world.m_5898_(null, 1011, pos, 0);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (state.m_60734_() != newState.m_60734_()) {
            world.m_46747_(pos);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getDoorItem());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public abstract Item getDoorItem();
}

