/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.SecurityCraftBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseFullMineBlock
extends ExplosiveBlock
implements IIntersectable,
IOverlayDisplay,
IBlockMine {
    private final Block blockDisguisedAs;

    public BaseFullMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties);
        this.blockDisguisedAs = disguisedBlock;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ctx;
        CollisionContext collisionContext2 = collisionContext;
        if (collisionContext2 instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext2).m_166012_().isPresent()) {
            Entity entity = (Entity)ctx.m_166012_().get();
            if (entity instanceof ItemEntity) {
                return Shapes.m_83144_();
            }
            Entity entity2 = entity;
            if (entity2 instanceof Player) {
                OwnableBlockEntity ownableTe;
                Player player = (Player)entity2;
                BlockEntity te = world.m_7702_(pos);
                BlockEntity blockEntity = te;
                if (blockEntity instanceof OwnableBlockEntity && (ownableTe = (OwnableBlockEntity)blockEntity).getOwner().isOwner(player)) {
                    return Shapes.m_83144_();
                }
            }
        }
        return Shapes.m_83040_();
    }

    @Override
    public void onEntityIntersected(Level world, BlockPos pos, Entity entity) {
        LivingEntity lEntity;
        if (entity instanceof ItemEntity) {
            return;
        }
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity && !PlayerUtils.isPlayerMountedOnCamera(lEntity = (LivingEntity)entity2) && !EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!world.f_46443_) {
            if (player != null && player.m_7500_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public boolean activateMine(Level world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean defuseMine(Level world, BlockPos pos) {
        return false;
    }

    @Override
    public void explode(Level world, BlockPos pos) {
        world.m_46961_(pos, false);
        world.m_46518_((Entity)null, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 2.5f : 5.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(Level world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SecurityCraftBlockEntity(pos, state).intersectsEntities();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BaseFullMineBlock.m_152132_(type, SCContent.beTypeAbstract, WorldUtils::blockEntityTicker);
    }

    @Override
    public ItemStack getDisplayStack(Level world, BlockState state, BlockPos pos) {
        return new ItemStack((ItemLike)this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(Level world, BlockState state, BlockPos pos) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        OwnableBlockEntity te;
        BlockEntity blockEntity;
        if (player.m_7500_() || (blockEntity = world.m_7702_(pos)) instanceof OwnableBlockEntity && (te = (OwnableBlockEntity)blockEntity).getOwner().isOwner(player)) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return new ItemStack((ItemLike)this.blockDisguisedAs);
    }

    public Block getBlockDisguisedAs() {
        return this.blockDisguisedAs;
    }
}

