/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClaymoreBlock
extends ExplosiveBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");
    private static final VoxelShape NORTH_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)7.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)5.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)5.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)4.0))))));
    private static final VoxelShape NORTH_ON = Shapes.m_83110_((VoxelShape)NORTH_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)2.0, (double)4.0, (double)5.0, (double)3.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)2.0, (double)13.0, (double)5.0, (double)3.0)));
    private static final VoxelShape EAST_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)5.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)11.0, (double)13.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape EAST_ON = Shapes.m_83110_((VoxelShape)EAST_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)4.0, (double)3.0, (double)14.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)5.0, (double)13.0)));
    private static final VoxelShape SOUTH_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)4.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)11.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)5.0, (double)13.0), (VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)13.0))))));
    private static final VoxelShape SOUTH_ON = Shapes.m_83110_((VoxelShape)SOUTH_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)13.0, (double)4.0, (double)5.0, (double)14.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)13.0, (double)13.0, (double)5.0, (double)14.0)));
    private static final VoxelShape WEST_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)7.0, (double)4.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)5.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)5.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)4.0, (double)5.0, (double)5.0), (VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)11.0, (double)4.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape WEST_ON = Shapes.m_83110_((VoxelShape)WEST_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)3.0, (double)3.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)5.0, (double)13.0)));

    public ClaymoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (world.m_8055_(pos.m_7495_()).m_60795_()) {
            world.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.m_7495_(), Direction.UP);
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!(player.m_7500_() || world.f_46443_ || ((Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue())) {
            world.m_46961_(pos, false);
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_ && world.m_8055_(pos).m_61138_((Property)DEACTIVATED) && !((Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_())).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean activateMine(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            world.m_46961_(pos, false);
            world.m_46518_((Entity)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.5f : 3.5f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield NORTH_OFF;
                }
                yield NORTH_ON;
            }
            case Direction.EAST -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield EAST_OFF;
                }
                yield EAST_ON;
            }
            case Direction.SOUTH -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield SOUTH_OFF;
                }
                yield SOUTH_ON;
            }
            case Direction.WEST -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield WEST_OFF;
                }
                yield WEST_ON;
            }
            default -> Shapes.m_83144_();
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(Level world, BlockPos pos) {
        return (Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClaymoreBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? null : ClaymoreBlock.m_152132_(type, SCContent.beTypeClaymore, WorldUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

