/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MineBlock
extends ExplosiveBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);

    public MineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (!world.m_8055_(pos.m_7495_()).m_60795_()) {
            return;
        }
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46961_(pos, true);
        } else {
            this.explode(world, pos);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.m_7495_(), Direction.UP);
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!world.f_46443_) {
            if (player != null && player.m_7500_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        LivingEntity lEntity;
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity && !PlayerUtils.isPlayerMountedOnCamera(lEntity = (LivingEntity)entity2) && !EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    @Override
    public boolean activateMine(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level world, BlockPos pos) {
        if (!world.f_46443_ && !((Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            world.m_46961_(pos, false);
            world.m_46518_((Entity)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.0f : 3.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)((Block)SCContent.MINE.get()).m_5456_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(Level world, BlockPos pos) {
        return (Boolean)world.m_8055_(pos).m_61143_((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }
}

