/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneOreMineBlock
extends BaseFullMineBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;

    public RedstoneOreMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties, disguisedBlock);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        RedstoneOreMineBlock.activate(state, world, pos);
        super.m_6256_(state, world, pos, player);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        RedstoneOreMineBlock.activate(state, world, pos);
        super.m_141947_(world, pos, state, entity);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            RedstoneOreMineBlock.spawnParticles(world, pos);
        } else {
            RedstoneOreMineBlock.activate(state, world, pos);
        }
        return stack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, hand, stack, hit).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void activate(BlockState state, Level world, BlockPos pos) {
        RedstoneOreMineBlock.spawnParticles(world, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            RedstoneOreMineBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        Random random = world.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.m_142300_(direction);
            if (world.m_8055_(offsetPos).m_60804_((BlockGetter)world, offsetPos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.nextFloat();
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }
}

