/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TrackMineBlock
extends RailBlock
implements IExplosive,
EntityBlock {
    public TrackMineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (PlayerUtils.isHoldingItem(player, SCContent.REMOTE_ACCESS_MINE, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (this.isActive(world, pos) && this.isDefusable() && player.m_21120_(hand).m_41720_() == SCContent.WIRE_CUTTERS.get() && this.defuseMine(world, pos)) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive(world, pos) && PlayerUtils.isHoldingItem(player, Items.f_42409_, hand) && this.activateMine(world, pos)) {
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return (Boolean)ConfigHandler.SERVER.ableToBreakMines.get() == false ? -1.0f : super.m_5880_(state, player, world, pos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        LivingEntity livingEntity = placer;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, player));
        }
    }

    public void onMinecartPass(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        TrackMineBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof TrackMineBlockEntity && (te = (TrackMineBlockEntity)blockEntity).isActive()) {
            world.m_46961_(pos, false);
            world.m_46518_((Entity)cart, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 4.0f : 8.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
            cart.m_6074_();
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        world.m_46747_(pos);
    }

    @Override
    public void explode(Level world, BlockPos pos) {
        TrackMineBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof TrackMineBlockEntity && (te = (TrackMineBlockEntity)blockEntity).isActive()) {
            world.m_46961_(pos, false);
            world.m_46518_((Entity)null, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 4.0f : 8.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    @Override
    public boolean activateMine(Level world, BlockPos pos) {
        TrackMineBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof TrackMineBlockEntity && !(te = (TrackMineBlockEntity)blockEntity).isActive()) {
            te.activate();
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level world, BlockPos pos) {
        TrackMineBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof TrackMineBlockEntity && (te = (TrackMineBlockEntity)blockEntity).isActive()) {
            te.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(Level world, BlockPos pos) {
        TrackMineBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        return blockEntity instanceof TrackMineBlockEntity && (te = (TrackMineBlockEntity)blockEntity).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrackMineBlockEntity(pos, state);
    }
}

