/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Map;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLayeredCauldronBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedCauldronBlock
extends AbstractCauldronBlock
implements IReinforcedBlock,
EntityBlock {
    public ReinforcedCauldronBlock(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> interactions) {
        super(properties, interactions);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        Entity entity;
        Entity entity2;
        EntityCollisionContext ctx;
        CollisionContext collisionContext2 = collisionContext;
        if (collisionContext2 instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext2).m_166012_().isPresent() && (entity2 = (entity = (Entity)ctx.m_166012_().get())) instanceof Player) {
            ReinforcedCauldronBlockEntity te;
            Player player = (Player)entity2;
            BlockEntity tile = world.m_7702_(pos);
            BlockEntity blockEntity = tile;
            if (blockEntity instanceof ReinforcedCauldronBlockEntity && (te = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
                return f_151937_;
            }
            return Shapes.m_83144_();
        }
        return f_151937_;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedCauldronBlockEntity te;
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof ReinforcedCauldronBlockEntity && (te = (ReinforcedCauldronBlockEntity)blockEntity).isAllowedToInteract(player)) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public boolean m_142596_(BlockState state) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(Level world, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return world.m_5822_().nextFloat() < 0.05f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return world.m_5822_().nextFloat() < 0.1f;
        }
        return false;
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (ReinforcedCauldronBlock.shouldHandlePrecipitation(world, precipitation)) {
            BlockEntity te = world.m_7702_(pos);
            if (precipitation == Biome.Precipitation.RAIN) {
                world.m_46597_(pos, ((Block)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_());
                world.m_151523_(te);
                world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
            } else if (precipitation == Biome.Precipitation.SNOW) {
                world.m_46597_(pos, ((Block)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).m_49966_());
                world.m_151523_(te);
                world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
            }
        }
    }

    protected boolean m_142087_(Fluid fluid) {
        return true;
    }

    protected void m_142310_(BlockState state, Level world, BlockPos pos, Fluid fluid) {
        BlockEntity te = world.m_7702_(pos);
        if (fluid == Fluids.f_76193_) {
            world.m_46597_(pos, ((Block)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_());
            world.m_151523_(te);
            world.m_46796_(1047, pos, 0);
            world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
        } else if (fluid == Fluids.f_76195_) {
            world.m_46597_(pos, ((Block)SCContent.REINFORCED_LAVA_CAULDRON.get()).m_49966_());
            world.m_151523_(te);
            world.m_46796_(1046, pos, 0);
            world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50256_;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.m_49966_();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        LivingEntity livingEntity = placer;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, player));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedCauldronBlockEntity(pos, state);
    }

    public static interface IReinforcedCauldronInteraction
    extends CauldronInteraction {
        public static final Map<Item, CauldronInteraction> EMPTY = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> WATER = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> LAVA = CauldronInteraction.m_175617_();
        public static final Map<Item, CauldronInteraction> POWDER_SNOW = CauldronInteraction.m_175617_();
        public static final CauldronInteraction FILL_WATER = (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(world, pos, player, hand, stack, (BlockState)((Block)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_);
        public static final CauldronInteraction FILL_LAVA = (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(world, pos, player, hand, stack, ((Block)SCContent.REINFORCED_LAVA_CAULDRON.get()).m_49966_(), SoundEvents.f_11780_);
        public static final CauldronInteraction FILL_POWDER_SNOW = (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.emptyBucket(world, pos, player, hand, stack, (BlockState)((Block)SCContent.REINFORCED_POWDER_SNOW_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_144076_);
        public static final CauldronInteraction SHULKER_BOX = (state, world, pos, player, hand, stack) -> {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (!(block instanceof ShulkerBoxBlock)) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                ItemStack shulker = new ItemStack((ItemLike)Blocks.f_50456_);
                if (stack.m_41782_()) {
                    shulker.m_41751_(stack.m_41783_().m_6426_());
                }
                player.m_21008_(hand, shulker);
                player.m_36220_(Stats.f_12947_);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, world, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        };
        public static final CauldronInteraction BANNER = (state, world, pos, player, hand, stack) -> {
            if (BannerBlockEntity.m_58504_((ItemStack)stack) <= 0) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                ItemStack banner = stack.m_41777_();
                banner.m_41764_(1);
                BannerBlockEntity.m_58509_((ItemStack)banner);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_()) {
                    player.m_21008_(hand, banner);
                } else if (player.m_150109_().m_36054_(banner)) {
                    player.f_36095_.m_150429_();
                } else {
                    player.m_36176_(banner, false);
                }
                player.m_36220_(Stats.f_12946_);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, world, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        };
        public static final CauldronInteraction DYED_ITEM = (state, world, pos, player, hand, stack) -> {
            Item item = stack.m_41720_();
            Item leatherItem$temp = item;
            if (!(leatherItem$temp instanceof DyeableLeatherItem)) {
                return InteractionResult.PASS;
            }
            DyeableLeatherItem leatherItem = (DyeableLeatherItem)leatherItem$temp;
            if (!leatherItem.m_41113_(stack)) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                leatherItem.m_41123_(stack);
                player.m_36220_(Stats.f_12945_);
                ReinforcedLayeredCauldronBlock.lowerFillLevel(state, world, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        };

        public static void bootStrap() {
            IReinforcedCauldronInteraction.addDefaultInteractions(EMPTY);
            EMPTY.put(Items.f_42589_, (state, world, pos, player, hand, stack) -> {
                if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                    return InteractionResult.PASS;
                }
                if (!world.f_46443_) {
                    Item item = stack.m_41720_();
                    BlockEntity te = world.m_7702_(pos);
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    world.m_46597_(pos, ((Block)SCContent.REINFORCED_WATER_CAULDRON.get()).m_49966_());
                    world.m_151523_(te);
                    world.m_5594_((Player)null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            });
            IReinforcedCauldronInteraction.addDefaultInteractions(WATER);
            WATER.put(Items.f_42446_, (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42447_), s -> (Integer)s.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
            WATER.put(Items.f_42590_, (state, world, pos, player, hand, stack) -> {
                if (!world.f_46443_) {
                    Item item = stack.m_41720_();
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                    ReinforcedLayeredCauldronBlock.lowerFillLevel(state, world, pos);
                    world.m_5594_((Player)null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_142346_((Entity)null, GameEvent.f_157816_, pos);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            });
            WATER.put(Items.f_42589_, (state, world, pos, player, hand, stack) -> {
                if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) != 3 && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                    if (!world.f_46443_) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                        player.m_36220_(Stats.f_12944_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                        world.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                        world.m_5594_((Player)null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                return InteractionResult.PASS;
            });
            WATER.put(Items.f_42463_, DYED_ITEM);
            WATER.put(Items.f_42462_, DYED_ITEM);
            WATER.put(Items.f_42408_, DYED_ITEM);
            WATER.put(Items.f_42407_, DYED_ITEM);
            WATER.put(Items.f_42654_, DYED_ITEM);
            WATER.put(Items.f_42660_, BANNER);
            WATER.put(Items.f_42667_, BANNER);
            WATER.put(Items.f_42728_, BANNER);
            WATER.put(Items.f_42671_, BANNER);
            WATER.put(Items.f_42672_, BANNER);
            WATER.put(Items.f_42669_, BANNER);
            WATER.put(Items.f_42673_, BANNER);
            WATER.put(Items.f_42663_, BANNER);
            WATER.put(Items.f_42668_, BANNER);
            WATER.put(Items.f_42665_, BANNER);
            WATER.put(Items.f_42662_, BANNER);
            WATER.put(Items.f_42661_, BANNER);
            WATER.put(Items.f_42666_, BANNER);
            WATER.put(Items.f_42670_, BANNER);
            WATER.put(Items.f_42727_, BANNER);
            WATER.put(Items.f_42664_, BANNER);
            WATER.put(Items.f_42266_, SHULKER_BOX);
            WATER.put(Items.f_42273_, SHULKER_BOX);
            WATER.put(Items.f_42229_, SHULKER_BOX);
            WATER.put(Items.f_42225_, SHULKER_BOX);
            WATER.put(Items.f_42226_, SHULKER_BOX);
            WATER.put(Items.f_42275_, SHULKER_BOX);
            WATER.put(Items.f_42227_, SHULKER_BOX);
            WATER.put(Items.f_42269_, SHULKER_BOX);
            WATER.put(Items.f_42274_, SHULKER_BOX);
            WATER.put(Items.f_42271_, SHULKER_BOX);
            WATER.put(Items.f_42268_, SHULKER_BOX);
            WATER.put(Items.f_42267_, SHULKER_BOX);
            WATER.put(Items.f_42272_, SHULKER_BOX);
            WATER.put(Items.f_42224_, SHULKER_BOX);
            WATER.put(Items.f_42228_, SHULKER_BOX);
            WATER.put(Items.f_42270_, SHULKER_BOX);
            LAVA.put(Items.f_42446_, (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42448_), s -> true, SoundEvents.f_11783_));
            IReinforcedCauldronInteraction.addDefaultInteractions(LAVA);
            POWDER_SNOW.put(Items.f_42446_, (state, world, pos, player, hand, stack) -> IReinforcedCauldronInteraction.fillBucket(state, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_151055_), level -> (Integer)level.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144089_));
            IReinforcedCauldronInteraction.addDefaultInteractions(POWDER_SNOW);
            CauldronInteraction.f_175607_.put((Item)SCContent.BRIEFCASE.get(), CauldronInteraction.f_175615_);
            WATER.put((Item)SCContent.BRIEFCASE.get(), DYED_ITEM);
        }

        public static void addDefaultInteractions(Map<Item, CauldronInteraction> interactions) {
            interactions.put(Items.f_42448_, FILL_LAVA);
            interactions.put(Items.f_42447_, FILL_WATER);
            interactions.put(Items.f_151055_, FILL_POWDER_SNOW);
        }

        public static InteractionResult fillBucket(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack bucket, Predicate<BlockState> fillPredicate, SoundEvent sound) {
            if (!fillPredicate.test(state)) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                Item item = stack.m_41720_();
                BlockEntity te = world.m_7702_(pos);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)bucket));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                world.m_46597_(pos, ((Block)SCContent.REINFORCED_CAULDRON.get()).m_49966_());
                world.m_151523_(te);
                world.m_5594_((Player)null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_((Entity)null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }

        public static InteractionResult emptyBucket(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent sound) {
            if (!world.f_46443_) {
                Item item = stack.m_41720_();
                BlockEntity te = world.m_7702_(pos);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
                player.m_36220_(Stats.f_12943_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                world.m_46597_(pos, state);
                world.m_151523_(te);
                world.m_5594_((Player)null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_((Entity)null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }
}

