/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReinforcedDoorBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public ReinforcedDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60734_() == this && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)facingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)facingState.m_61143_(HINGE))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(world, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf;
        if (!world.f_46443_ && player.m_7500_() && (doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
            case PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            default -> false;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (pos.m_123342_() < world.m_141928_() && context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context)) {
            boolean flag = world.m_46753_(pos) || world.m_46753_(pos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHingeSide(context))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.onNeighborChanged(world, pos, fromPos);
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext p_208073_1_) {
        boolean flag1;
        Level iblockreader = p_208073_1_.m_43725_();
        BlockPos blockpos = p_208073_1_.m_8083_();
        Direction direction = p_208073_1_.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_142300_(direction1);
        BlockState blockstate = iblockreader.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_142300_(direction1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_142300_(direction2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_142300_(direction2);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60734_() == this && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.m_60734_() == this && blockstate2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3d = p_208073_1_.m_43720_();
                double d0 = vec3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void onNeighborChanged(Level world, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        BlockState state = world.m_8055_(pos);
        Block neighborBlock = world.m_8055_(neighbor).m_60734_();
        Owner previousOwner = null;
        if (world.m_7702_(pos) instanceof OwnableBlockEntity) {
            previousOwner = ((OwnableBlockEntity)world.m_7702_(pos)).getOwner();
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = pos.m_7495_();
            BlockState stateBelow = world.m_8055_(blockBelow);
            if (stateBelow.m_60734_() != this) {
                world.m_46961_(pos, false);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = pos.m_7494_();
            BlockState stateAbove = world.m_8055_(blockAbove);
            if (stateAbove.m_60734_() != this) {
                world.m_46961_(pos, false);
                drop = true;
            }
            if (!BlockUtils.isSideSolid((LevelReader)world, pos.m_7495_(), Direction.UP)) {
                world.m_46961_(pos, false);
                drop = true;
                if (stateAbove.m_60734_() == this) {
                    world.m_46961_(pos, false);
                }
            }
            if (drop) {
                if (!world.f_46443_) {
                    world.m_46961_(pos, false);
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()));
                }
            } else {
                boolean hasActiveSCBlock;
                boolean bl = hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, pos.m_7494_());
                if (neighborBlock != this && hasActiveSCBlock != (Boolean)stateAbove.m_61143_((Property)OPEN) && hasActiveSCBlock != (Boolean)state.m_61143_((Property)OPEN)) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                    if (state.m_61143_((Property)FACING) == Direction.WEST) {
                        BlockState secondDoorState = world.m_8055_(pos.m_142127_());
                        if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                            world.m_7731_(pos.m_142127_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.m_8055_(pos.m_142128_());
                            if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                                world.m_7731_(pos.m_142128_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.m_61143_((Property)FACING) == Direction.NORTH) {
                        BlockState secondDoorState = world.m_8055_(pos.m_142126_());
                        if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                            world.m_7731_(pos.m_142126_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.m_8055_(pos.m_142125_());
                            if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                                world.m_7731_(pos.m_142125_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.m_61143_((Property)FACING) == Direction.EAST) {
                        BlockState secondDoorState = world.m_8055_(pos.m_142128_());
                        if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                            world.m_7731_(pos.m_142128_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.m_8055_(pos.m_142127_());
                            if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                                world.m_7731_(pos.m_142127_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    } else if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
                        BlockState secondDoorState = world.m_8055_(pos.m_142125_());
                        if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                            world.m_7731_(pos.m_142125_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                        } else {
                            secondDoorState = world.m_8055_(pos.m_142126_());
                            if (secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && (Boolean)secondDoorState.m_61143_((Property)OPEN) != hasActiveSCBlock) {
                                world.m_7731_(pos.m_142126_(), (BlockState)secondDoorState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            }
                        }
                    }
                    world.m_5898_((Player)null, hasActiveSCBlock ? 1005 : 1011, pos, 0);
                }
            }
        }
        if (previousOwner != null && (blockEntity = world.m_7702_(pos)) instanceof OwnableBlockEntity) {
            OwnableBlockEntity thisTe = (OwnableBlockEntity)blockEntity;
            blockEntity = world.m_7702_(pos.m_7494_());
            if (blockEntity instanceof OwnableBlockEntity) {
                OwnableBlockEntity aboveTe = (OwnableBlockEntity)blockEntity;
                thisTe.setOwner(previousOwner.getUUID(), previousOwner.getName());
                aboveTe.setOwner(previousOwner.getUUID(), previousOwner.getName());
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos posBelow = pos.m_7495_();
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return state.m_60783_((BlockGetter)world, posBelow, Direction.UP);
        }
        return state.m_60734_() == this;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (state.m_60734_() != newState.m_60734_()) {
            world.m_46747_(pos);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE});
    }
}

