/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ItemStack disguisedAs = ItemStack.f_41583_;
            Block disguisedBlock$temp = blockState.m_60734_();
            if (disguisedBlock$temp instanceof DisguisableBlock) {
                DisguisableBlock disguisedBlock = (DisguisableBlock)disguisedBlock$temp;
                disguisedAs = disguisedBlock.getDisguisedStack((BlockGetter)world, data.getPos());
            } else {
                Block display$temp = blockState.m_60734_();
                if (display$temp instanceof IOverlayDisplay) {
                    IOverlayDisplay display = (IOverlayDisplay)display$temp;
                    disguisedAs = display.getDisplayStack(world, blockState, data.getPos());
                }
            }
            if (!disguisedAs.m_41619_()) {
                probeInfo.horizontal().item(disguisedAs).vertical().itemLabel(disguisedAs).text((Component)new TextComponent(ChatFormatting.BLUE + ChatFormatting.ITALIC + ((ModContainer)ModList.get().getModContainerById(disguisedAs.m_41720_().getRegistryName().m_135827_()).get()).getModInfo().getDisplayName()));
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("securitycraft", "securitycraft");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
                INameable nameable;
                Object password;
                Object ownable;
                Object object;
                IOverlayDisplay display;
                Block block = blockState.m_60734_();
                Block block2 = block;
                if (block2 instanceof IOverlayDisplay && !(display = (IOverlayDisplay)block2).shouldShowSCInfo(world, blockState, data.getPos())) {
                    return;
                }
                BlockEntity te = world.m_7702_(data.getPos());
                BlockEntity blockEntity = te;
                if (blockEntity instanceof IOwnable) {
                    IOwnable ownable2 = (IOwnable)blockEntity;
                    probeInfo.vertical().text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ownable2.getOwner().getName()).getString()));
                }
                if ((object = te) instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)object;
                    object = te;
                    if (!(object instanceof IOwnable && !(ownable = (IOwnable)object).getOwner().isOwner(player) || inv.getInsertedModules().isEmpty())) {
                        probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).getString()));
                        for (ModuleType module : inv.getInsertedModules()) {
                            probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())));
                        }
                    }
                }
                if ((ownable = te) instanceof IPasswordProtected) {
                    IPasswordProtected passwordProtected = (IPasswordProtected)ownable;
                    if (!(te instanceof KeycardReaderBlockEntity) && ((IOwnable)te).getOwner().isOwner(player)) {
                        password = passwordProtected.getPassword();
                        probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:password", password != null && !((String)password).isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])).getString()));
                    }
                }
                if ((password = te) instanceof INameable && (nameable = (INameable)password).canBeNamed()) {
                    Component text = nameable.getCustomSCName();
                    Component name = text == null ? TextComponent.f_131282_ : text;
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:customName", nameable.hasCustomSCName() ? name : Utils.localize("waila.securitycraft:customName.notSet", new Object[0])).getString()));
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level world, Entity entity, IProbeHitEntityData data) {
                Entity entity2 = entity;
                if (entity2 instanceof Sentry) {
                    Sentry sentry = (Sentry)entity2;
                    Sentry.SentryMode mode = sentry.getMode();
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ((Sentry)entity).getOwner().getName()).getString()));
                    if (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule()) {
                        probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).getString()));
                        if (!sentry.getAllowlistModule().m_41619_()) {
                            probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.ALLOWLIST.getTranslationKey())));
                        }
                        if (!sentry.getDisguiseModule().m_41619_()) {
                            probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.DISGUISE.getTranslationKey())));
                        }
                        if (sentry.hasSpeedModule()) {
                            probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.SPEED.getTranslationKey())));
                        }
                    }
                    TranslatableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
                    if (mode != Sentry.SentryMode.IDLE) {
                        modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
                    }
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + modeDescription.getString()));
                }
            }
        });
        return null;
    }
}

