/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.ui.ItemStackElement;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPaneBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.RegistryObject;

@WailaPlugin(value="securitycraft")
public class WailaDataProvider
implements IWailaPlugin,
IComponentProvider,
IEntityComponentProvider {
    public static final WailaDataProvider INSTANCE = new WailaDataProvider();
    public static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    public static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    public static final ResourceLocation SHOW_PASSWORDS = new ResourceLocation("securitycraft", "showpasswords");
    public static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");

    public void register(IRegistrar registrar) {
        registrar.addConfig(SHOW_OWNER, true);
        registrar.addConfig(SHOW_MODULES, true);
        registrar.addConfig(SHOW_PASSWORDS, true);
        registrar.addConfig(SHOW_CUSTOM_NAME, true);
        for (RegistryObject registryObject : SCContent.BLOCKS.getEntries()) {
            Block block = (Block)registryObject.get();
            if (!(block instanceof OwnableBlock || block.getRegistryName().m_135815_().matches("(?!(reinforced_)).*?crystal_.*") || block instanceof ReinforcedCauldronBlock || block instanceof ReinforcedPaneBlock)) {
                registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, block.getClass());
            }
            if (!(block instanceof IOverlayDisplay)) continue;
            registrar.usePickedResult(block);
        }
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, OwnableBlock.class);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, ReinforcedCauldronBlock.class);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, ReinforcedPaneBlock.class);
        registrar.registerIconProvider((IComponentProvider)INSTANCE, DisguisableBlock.class);
        registrar.registerComponentProvider((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, Sentry.class);
    }

    public IElement getIcon(BlockAccessor data, IPluginConfig config, IElement currentIcon) {
        Block block = data.getBlock();
        if (block instanceof IOverlayDisplay) {
            IOverlayDisplay display = (IOverlayDisplay)block;
            return ItemStackElement.of((ItemStack)display.getDisplayStack(data.getLevel(), data.getBlockState(), data.getPosition()));
        }
        return ItemStackElement.EMPTY;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor data, IPluginConfig config) {
        if (data.getTooltipPosition() == TooltipPosition.BODY) {
            IOverlayDisplay display;
            DisguisableBlock disguisedBlock;
            Block disguisedBlockState;
            Block block = data.getBlock();
            boolean disguised = false;
            Block block2 = block;
            if (block2 instanceof DisguisableBlock && (disguisedBlockState = (disguisedBlock = (DisguisableBlock)block2).getDisguisedBlockState((BlockGetter)data.getLevel(), data.getPosition())) != null) {
                disguised = true;
                block = disguisedBlockState.m_60734_();
            }
            if ((disguisedBlockState = block) instanceof IOverlayDisplay && !(display = (IOverlayDisplay)disguisedBlockState).shouldShowSCInfo(data.getLevel(), data.getBlockState(), data.getPosition())) {
                return;
            }
            BlockEntity te = data.getBlockEntity();
            if (te != null) {
                INameable nameable;
                Object password;
                Object ownable;
                Object object;
                BlockEntity blockEntity;
                if (config.get(SHOW_OWNER) && (blockEntity = te) instanceof IOwnable) {
                    IOwnable ownable2 = (IOwnable)blockEntity;
                    if (block.getRegistryName().m_135827_().equals("securitycraft")) {
                        tooltip.add((Component)Utils.localize("waila.securitycraft:owner", ownable2.getOwner().getName()));
                    }
                }
                if (disguised) {
                    return;
                }
                if (config.get(SHOW_MODULES) && (object = te) instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)object;
                    object = te;
                    if (!(object instanceof IOwnable) || (ownable = (IOwnable)object).getOwner().isOwner(data.getPlayer())) {
                        if (!inv.getInsertedModules().isEmpty()) {
                            tooltip.add((Component)Utils.localize("waila.securitycraft:equipped", new Object[0]));
                        }
                        for (ModuleType module : inv.getInsertedModules()) {
                            tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())));
                        }
                    }
                }
                if (config.get(SHOW_PASSWORDS) && (ownable = te) instanceof IPasswordProtected) {
                    IPasswordProtected ipp = (IPasswordProtected)ownable;
                    if (((IOwnable)te).getOwner().isOwner(data.getPlayer())) {
                        password = ipp.getPassword();
                        tooltip.add((Component)Utils.localize("waila.securitycraft:password", password != null && !((String)password).isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])));
                    }
                }
                if (config.get(SHOW_CUSTOM_NAME) && (password = te) instanceof INameable && (nameable = (INameable)password).canBeNamed()) {
                    Component text = nameable.getCustomSCName();
                    tooltip.add((Component)Utils.localize("waila.securitycraft:customName", nameable.hasCustomSCName() ? text : Utils.localize("waila.securitycraft:customName.notSet", new Object[0])));
                }
            }
        }
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor data, IPluginConfig config) {
        Entity entity;
        Entity entity2;
        if (data.getTooltipPosition() == TooltipPosition.BODY && (entity2 = (entity = data.getEntity())) instanceof Sentry) {
            Sentry sentry = (Sentry)entity2;
            Sentry.SentryMode mode = sentry.getMode();
            if (config.get(SHOW_OWNER)) {
                tooltip.add((Component)Utils.localize("waila.securitycraft:owner", sentry.getOwner().getName()));
            }
            if (config.get(SHOW_MODULES) && sentry.getOwner().isOwner(data.getPlayer()) && (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule())) {
                tooltip.add((Component)Utils.localize("waila.securitycraft:equipped", new Object[0]));
                if (!sentry.getAllowlistModule().m_41619_()) {
                    tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.ALLOWLIST.getTranslationKey())));
                }
                if (!sentry.getDisguiseModule().m_41619_()) {
                    tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.DISGUISE.getTranslationKey())));
                }
                if (sentry.hasSpeedModule()) {
                    tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.SPEED.getTranslationKey())));
                }
            }
            TranslatableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            tooltip.add((Component)modeDescription);
        }
    }
}

