/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetCameraRotation;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SecurityCamera
extends Entity {
    private final double CAMERA_SPEED;
    private double cameraUseX;
    private double cameraUseY;
    private double cameraUseZ;
    private float cameraUseYaw;
    private float cameraUsePitch;
    private int id;
    public int screenshotSoundCooldown;
    private int redstoneCooldown;
    private int toggleNightVisionCooldown;
    private int toggleLightCooldown;
    private boolean shouldProvideNightVision;
    private float zoomAmount;
    private boolean zooming;

    public SecurityCamera(EntityType<SecurityCamera> type, Level world) {
        super(SCContent.eTypeSecurityCamera, world);
        this.CAMERA_SPEED = (Double)ConfigHandler.CLIENT.cameraSpeed.get();
        this.screenshotSoundCooldown = 0;
        this.redstoneCooldown = 0;
        this.toggleNightVisionCooldown = 0;
        this.toggleLightCooldown = 0;
        this.shouldProvideNightVision = false;
        this.zoomAmount = 1.0f;
        this.zooming = false;
        this.f_19794_ = true;
    }

    public SecurityCamera(Level world, BlockPos pos, int id, Player player) {
        this(SCContent.eTypeSecurityCamera, world);
        BlockEntity te;
        this.cameraUseX = player.m_20185_();
        this.cameraUseY = player.m_20186_();
        this.cameraUseZ = player.m_20189_();
        this.cameraUseYaw = player.m_146908_();
        this.cameraUsePitch = player.m_146909_();
        this.id = id;
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        BlockEntity blockEntity = te = world.m_7702_(this.m_142538_());
        if (blockEntity instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
            this.setInitialPitchYaw(cam);
        }
    }

    public SecurityCamera(Level world, BlockPos pos, int id, SecurityCamera camera) {
        this(SCContent.eTypeSecurityCamera, world);
        BlockEntity te;
        this.cameraUseX = camera.cameraUseX;
        this.cameraUseY = camera.cameraUseY;
        this.cameraUseZ = camera.cameraUseZ;
        this.cameraUseYaw = camera.cameraUseYaw;
        this.cameraUsePitch = camera.cameraUsePitch;
        this.id = id;
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        BlockEntity blockEntity = te = world.m_7702_(this.m_142538_());
        if (blockEntity instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
            this.setInitialPitchYaw(cam);
        }
    }

    private void setInitialPitchYaw(SecurityCameraBlockEntity te) {
        if (te != null && te.hasModule(ModuleType.SMART) && te.lastPitch != Float.MAX_VALUE && te.lastYaw != Float.MAX_VALUE) {
            this.m_146926_(te.lastPitch);
            this.m_146922_(te.lastYaw);
        } else {
            this.m_146926_(30.0f);
            Direction facing = (Direction)this.f_19853_.m_8055_(this.m_142538_()).m_61143_((Property)SecurityCameraBlock.FACING);
            if (facing == Direction.NORTH) {
                this.m_146922_(180.0f);
            } else if (facing == Direction.WEST) {
                this.m_146922_(90.0f);
            } else if (facing == Direction.SOUTH) {
                this.m_146922_(0.0f);
            } else if (facing == Direction.EAST) {
                this.m_146922_(270.0f);
            } else if (facing == Direction.DOWN) {
                this.m_146922_(75.0f);
            }
        }
    }

    public double m_6048_() {
        return -0.75;
    }

    protected boolean m_6093_() {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_ && this.m_20160_()) {
            Player lowestEntity = (Player)this.m_20197_().get(0);
            if (lowestEntity != Minecraft.m_91087_().f_91074_) {
                return;
            }
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.toggleLightCooldown > 0) {
                --this.toggleLightCooldown;
            }
            if (lowestEntity.m_146908_() != this.m_146908_()) {
                lowestEntity.m_19890_(lowestEntity.m_20185_(), lowestEntity.m_20186_(), lowestEntity.m_20189_(), this.m_146908_(), this.m_146909_());
                lowestEntity.m_146922_(this.m_146908_());
            }
            if (lowestEntity.m_146909_() != this.m_146909_()) {
                lowestEntity.m_19890_(lowestEntity.m_20185_(), lowestEntity.m_20186_(), lowestEntity.m_20189_(), this.m_146908_(), this.m_146909_());
            }
            this.checkKeysPressed();
            if (this.m_20197_().size() != 0 && this.shouldProvideNightVision) {
                SecurityCraft.channel.sendToServer((Object)new GiveNightVision());
            }
        }
        if (!(this.f_19853_.f_46443_ || this.m_20197_().size() != 0 && this.f_19853_.m_8055_(this.m_142538_()).m_60734_() == SCContent.SECURITY_CAMERA.get())) {
            this.m_146870_();
            return;
        }
    }

    private void checkKeysPressed() {
        if (Minecraft.m_91087_().f_91066_.f_92085_.m_90857_()) {
            this.moveViewUp();
        }
        if (Minecraft.m_91087_().f_91066_.f_92087_.m_90857_()) {
            this.moveViewDown();
        }
        if (Minecraft.m_91087_().f_91066_.f_92086_.m_90857_()) {
            this.moveViewLeft();
        }
        if (Minecraft.m_91087_().f_91066_.f_92088_.m_90857_()) {
            this.moveViewRight();
        }
        if (KeyBindings.cameraEmitRedstone.m_90859_() && this.redstoneCooldown == 0) {
            this.setRedstonePower();
            this.redstoneCooldown = 30;
        }
        if (KeyBindings.cameraActivateNightVision.m_90859_() && this.toggleNightVisionCooldown == 0) {
            this.enableNightVision();
        }
        if (KeyBindings.cameraZoomIn.m_90859_()) {
            this.zoomIn();
            this.zooming = true;
        } else if (KeyBindings.cameraZoomOut.m_90859_()) {
            this.zoomOut();
            this.zooming = true;
        } else {
            this.zooming = false;
        }
    }

    public void moveViewUp() {
        if (this.isCameraDown()) {
            if (this.m_146909_() > 40.0f) {
                this.m_19915_(this.m_146908_(), (float)((double)this.m_146909_() - this.CAMERA_SPEED));
            }
        } else if (this.m_146909_() > -25.0f) {
            this.m_19915_(this.m_146908_(), (float)((double)this.m_146909_() - this.CAMERA_SPEED));
        }
        this.updateServerRotation();
    }

    public void moveViewDown() {
        if (this.isCameraDown()) {
            if (this.m_146909_() < 100.0f) {
                this.m_19915_(this.m_146908_(), (float)((double)this.m_146909_() + this.CAMERA_SPEED));
            }
        } else if (this.m_146909_() < 60.0f) {
            this.m_19915_(this.m_146908_(), (float)((double)this.m_146909_() + this.CAMERA_SPEED));
        }
        this.updateServerRotation();
    }

    public void moveViewLeft() {
        BlockState state = this.f_19853_.m_8055_(this.m_142538_());
        if (state.m_61138_((Property)SecurityCameraBlock.FACING)) {
            Direction facing = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
            float xRot = this.m_146909_();
            float yRot = this.m_146908_();
            if (facing == Direction.EAST) {
                if ((double)yRot - this.CAMERA_SPEED > -180.0) {
                    this.m_19915_((float)((double)yRot - this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.WEST) {
                if ((double)yRot - this.CAMERA_SPEED > 0.0) {
                    this.m_19915_((float)((double)yRot - this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.NORTH) {
                if ((double)yRot - this.CAMERA_SPEED > 90.0 && (double)yRot - this.CAMERA_SPEED < 185.0 || (double)yRot - this.CAMERA_SPEED > -190.0 && (double)yRot - this.CAMERA_SPEED < -90.0) {
                    this.m_19915_((float)((double)yRot - this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.SOUTH) {
                if ((double)yRot - this.CAMERA_SPEED > -90.0) {
                    this.m_19915_((float)((double)yRot - this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.DOWN) {
                this.m_19915_((float)((double)yRot - this.CAMERA_SPEED), xRot);
            }
            this.updateServerRotation();
        }
    }

    public void moveViewRight() {
        BlockState state = this.f_19853_.m_8055_(this.m_142538_());
        if (state.m_61138_((Property)SecurityCameraBlock.FACING)) {
            Direction facing = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
            float xRot = this.m_146909_();
            float yRot = this.m_146908_();
            if (facing == Direction.EAST) {
                if ((double)yRot + this.CAMERA_SPEED < 0.0) {
                    this.m_19915_((float)((double)yRot + this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.WEST) {
                if ((double)yRot + this.CAMERA_SPEED < 180.0) {
                    this.m_19915_((float)((double)yRot + this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.NORTH) {
                if ((double)yRot + this.CAMERA_SPEED > 85.0 && (double)yRot + this.CAMERA_SPEED < 185.0 || (double)yRot + this.CAMERA_SPEED < -95.0 && (double)yRot + this.CAMERA_SPEED > -180.0) {
                    this.m_19915_((float)((double)yRot + this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.SOUTH) {
                if ((double)yRot + this.CAMERA_SPEED < 90.0) {
                    this.m_19915_((float)((double)yRot + this.CAMERA_SPEED), xRot);
                }
            } else if (facing == Direction.DOWN) {
                this.m_19915_((float)((double)yRot + this.CAMERA_SPEED), xRot);
            }
            this.updateServerRotation();
        }
    }

    public void zoomIn() {
        this.zoomAmount = Math.max(this.zoomAmount - 0.1f, 0.1f);
        if (!this.zooming) {
            Minecraft.m_91087_().f_91073_.m_104677_(this.m_142538_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void zoomOut() {
        this.zoomAmount = Math.min(this.zoomAmount + 0.1f, 1.5f);
        if (!this.zooming) {
            Minecraft.m_91087_().f_91073_.m_104677_(this.m_142538_(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void setRedstonePower() {
        BlockPos pos = this.m_142538_();
        if (((IModuleInventory)this.f_19853_.m_7702_(pos)).hasModule(ModuleType.REDSTONE)) {
            SecurityCraft.channel.sendToServer((Object)new SetCameraPowered(pos, (Boolean)this.f_19853_.m_8055_(pos).m_61143_((Property)SecurityCameraBlock.POWERED) == false));
        }
    }

    public void enableNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    private void updateServerRotation() {
        SecurityCraft.channel.sendToServer((Object)new SetCameraRotation(this.m_146908_(), this.m_146909_()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCameraDown() {
        BlockEntity blockEntity = this.f_19853_.m_7702_(this.m_142538_());
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) return false;
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
        if (!cam.down) return false;
        return true;
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        livingEntity.m_146922_(this.cameraUseYaw % 360.0f);
        livingEntity.m_146926_(Mth.m_14036_((float)this.cameraUsePitch, (float)-90.0f, (float)90.0f) % 360.0f);
        livingEntity.f_19859_ = livingEntity.m_146908_();
        livingEntity.f_19860_ = livingEntity.m_146909_();
        return this.getPreviousPlayerPos();
    }

    public Vec3 getPreviousPlayerPos() {
        return new Vec3(this.cameraUseX, this.cameraUseY, this.cameraUseZ);
    }

    protected void m_8097_() {
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128405_("CameraID", this.id);
        tag.m_128347_("cameraUseX", this.cameraUseX);
        tag.m_128347_("cameraUseY", this.cameraUseY);
        tag.m_128347_("cameraUseZ", this.cameraUseZ);
        tag.m_128347_("cameraUseYaw", (double)this.cameraUseYaw);
        tag.m_128347_("cameraUsePitch", (double)this.cameraUsePitch);
    }

    public void m_7378_(CompoundTag tag) {
        this.id = tag.m_128451_("CameraID");
        this.cameraUseX = tag.m_128459_("cameraUseX");
        this.cameraUseY = tag.m_128459_("cameraUseY");
        this.cameraUseZ = tag.m_128459_("cameraUseZ");
        this.cameraUseYaw = tag.m_128457_("cameraUseYaw");
        this.cameraUsePitch = tag.m_128457_("cameraUsePitch");
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

