/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.entity.Bullet;
import net.geforcemods.securitycraft.entity.ai.AttackRangedIfEnabledGoal;
import net.geforcemods.securitycraft.entity.ai.TargetNearestPlayerOrMobGoal;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Sentry
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.m_135353_(Sentry.class, Owner.getSerializer());
    private static final EntityDataAccessor<CompoundTag> DISGUISE_MODULE = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<CompoundTag> ALLOWLIST = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> HAS_SPEED_MODULE = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MODE = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> HEAD_ROTATION = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private static final float ANIMATION_STEP_SIZE = 0.025f;
    private static final float UPWARDS_ANIMATION_LIMIT = 0.025f;
    private static final float DOWNWARDS_ANIMATION_LIMIT = 0.9f;
    private float headYTranslation = 0.9f;
    public boolean animateUpwards = false;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public Sentry(EntityType<Sentry> type, Level world) {
        super(SCContent.eTypeSentry, world);
    }

    public void setupSentry(Player owner) {
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(owner.m_7755_().getString(), Player.m_36198_((GameProfile)owner.m_36316_()).toString()));
        this.f_19804_.m_135381_(DISGUISE_MODULE, (Object)new CompoundTag());
        this.f_19804_.m_135381_(ALLOWLIST, (Object)new CompoundTag());
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)false);
        this.f_19804_.m_135381_(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, (Object)new Owner());
        this.f_19804_.m_135372_(DISGUISE_MODULE, (Object)new CompoundTag());
        this.f_19804_.m_135372_(ALLOWLIST, (Object)new CompoundTag());
        this.f_19804_.m_135372_(HAS_SPEED_MODULE, (Object)false);
        this.f_19804_.m_135372_(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.f_19804_.m_135372_(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackRangedIfEnabledGoal(this, this::getShootingSpeed, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new TargetNearestPlayerOrMobGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            BlockPos downPos = this.m_20099_();
            if (this.f_19853_.m_8055_(downPos).m_60795_() || this.f_19853_.m_45772_(new AABB(downPos))) {
                this.m_146870_();
            }
        } else {
            if (!this.animate && this.headYTranslation > 0.0f && this.getMode().isAggressive()) {
                this.animateUpwards = true;
                this.animate = true;
            }
            if (this.animate) {
                if (this.animateUpwards && this.headYTranslation > 0.025f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.025f) {
                        this.animateUpwards = false;
                        this.animate = false;
                    }
                } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.animateUpwards = true;
                        this.animate = false;
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SCContent.SENTRY.get());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        BlockPos pos = this.m_142538_();
        if (this.getOwner().isOwner(player) && hand == InteractionHand.MAIN_HAND) {
            Item item = player.m_21205_().m_41720_();
            player.m_6915_();
            if (player.m_6047_()) {
                this.m_146870_();
            } else if (item == SCContent.UNIVERSAL_BLOCK_REMOVER.get()) {
                this.m_6074_();
                if (!player.m_7500_()) {
                    player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
            } else if (item == SCContent.DISGUISE_MODULE.get()) {
                ItemStack module = this.getDisguiseModule();
                if (!module.m_41619_()) {
                    Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)module);
                    ArrayList<Block> blocks = ((ModuleItem)module.m_41720_()).getBlockAddons(module.m_41783_());
                    if (blocks.size() > 0 && blocks.get(0) == this.f_19853_.m_8055_(pos).m_60734_()) {
                        this.f_19853_.m_7471_(pos, false);
                    }
                }
                this.setDisguiseModule(player.m_21205_());
                if (!player.m_7500_()) {
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else if (item == SCContent.ALLOWLIST_MODULE.get()) {
                ItemStack module = this.getAllowlistModule();
                if (!module.m_41619_()) {
                    Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)module);
                }
                this.setAllowlistModule(player.m_21205_());
                if (!player.m_7500_()) {
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else if (item == SCContent.SPEED_MODULE.get()) {
                if (!this.hasSpeedModule()) {
                    this.setHasSpeedModule(true);
                    if (!player.m_7500_()) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    }
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get()) {
                ArrayList<Block> blocks;
                if (!this.getDisguiseModule().m_41619_() && (blocks = ((ModuleItem)this.getDisguiseModule().m_41720_()).getBlockAddons(this.getDisguiseModule().m_41783_())).size() > 0 && blocks.get(0) == this.f_19853_.m_8055_(pos).m_60734_()) {
                    this.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
                Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
                if (this.hasSpeedModule()) {
                    Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
                }
                this.f_19804_.m_135381_(DISGUISE_MODULE, (Object)new CompoundTag());
                this.f_19804_.m_135381_(ALLOWLIST, (Object)new CompoundTag());
                this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)false);
            } else if (item == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                item.m_6225_(new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false)));
            } else if (item == Items.f_42656_) {
                this.m_6593_(player.m_21205_().m_41786_());
                player.m_21205_().m_41774_(1);
            } else if (item == SCContent.UNIVERSAL_OWNER_CHANGER.get()) {
                String newOwner;
                this.f_19804_.m_135381_(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.m_21205_().m_41786_().getString()) ? PlayerUtils.getPlayerFromName(newOwner).m_142081_().toString() : "ownerUUID"));
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
            } else {
                this.toggleMode(player);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        if (!this.getOwner().isOwner(player) && hand == InteractionHand.MAIN_HAND && player.m_7500_() && (player.m_6047_() || player.m_21205_().m_41720_() == SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
            this.m_6074_();
        }
        return super.m_6071_(player, hand);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        ArrayList<Block> blocks;
        BlockPos pos = this.m_142538_();
        if (!this.getDisguiseModule().m_41619_() && (blocks = ((ModuleItem)this.getDisguiseModule().m_41720_()).getBlockAddons(this.getDisguiseModule().m_41783_())).size() > 0 && blocks.get(0) == this.f_19853_.m_8055_(pos).m_60734_()) {
            this.f_19853_.m_7471_(pos, false);
        }
        super.m_142687_(reason);
        Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SENTRY.get()));
        Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
        if (this.hasSpeedModule()) {
            Block.m_49840_((Level)this.f_19853_, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
        }
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void toggleMode(Player player) {
        this.toggleMode(player, (Integer)this.f_19804_.m_135370_(MODE) + 1, true);
    }

    public void toggleMode(Player player, int mode, boolean sendMessage) {
        if (mode < 0 || mode >= SentryMode.values().length) {
            mode = 0;
        }
        this.f_19804_.m_135381_(MODE, (Object)mode);
        if (sendMessage) {
            player.m_5661_((Component)Utils.localize(SentryMode.values()[mode].getModeKey(), new Object[0]).m_7220_((Component)Utils.localize(SentryMode.values()[mode].getDescriptionKey(), new Object[0])), true);
        }
        if (!player.f_19853_.f_46443_) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.m_142538_(), true, SentryMode.values()[mode].isAggressive()));
        }
    }

    public void m_6710_(LivingEntity target) {
        if (!this.getMode().isAggressive() && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.m_142049_())) {
            this.animateUpwards = this.getMode().isCamouflage() && target != null;
            this.animate = true;
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.m_142538_(), this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.m_142049_();
        super.m_6710_(target);
    }

    public float m_20236_(Pose pose) {
        return 1.5f;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        Player player;
        LivingEntity livingEntity = target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_5833_() || player.m_7500_())) {
            return;
        }
        if (this.m_20280_((Entity)target) > 400.0) {
            return;
        }
        BlockEntity tile = this.f_19853_.m_7702_(this.m_142538_().m_7495_());
        Bullet throwableEntity = null;
        SoundEvent shootSound = SoundEvents.f_11687_;
        AbstractProjectileDispenseBehavior pdb = null;
        LazyOptional optional = LazyOptional.empty();
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity te = (KeypadChestBlockEntity)blockEntity;
            optional = te.getHandlerForSentry(this);
        } else if (tile != null) {
            optional = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                DispenseItemBehavior dispenseBehavior;
                DispenseItemBehavior dispenseItemBehavior;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_() || !((dispenseItemBehavior = (dispenseBehavior = ((DispenserBlock)Blocks.f_50061_).m_7216_(stack))) instanceof AbstractProjectileDispenseBehavior)) continue;
                AbstractProjectileDispenseBehavior projectileDispenseBehavior = (AbstractProjectileDispenseBehavior)dispenseItemBehavior;
                ItemStack extracted = handler.extractItem(i, 1, false);
                pdb = projectileDispenseBehavior;
                throwableEntity = pdb.m_6895_(this.f_19853_, (Position)this.m_20182_().m_82520_(0.0, 1.6, 0.0), extracted);
                throwableEntity.m_5602_((Entity)this);
                shootSound = null;
                break;
            }
        }
        if (throwableEntity == null) {
            throwableEntity = new Bullet(this.f_19853_, this);
        }
        double baseY = target.m_20186_() + (double)target.m_20192_() - (double)1.1f;
        double x = target.m_20185_() - this.m_20185_();
        double y = baseY - throwableEntity.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        float yOffset = Mth.m_14116_((float)((float)(x * x + z * z))) * 0.2f;
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf((float)(Mth.m_14136_((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.m_6686_(x, y + (double)yOffset, z, 1.6f, 0.0f);
        if (shootSound == null) {
            if (!this.f_19853_.f_46443_) {
                pdb.m_6823_((BlockSource)new BlockSourceImpl((ServerLevel)this.f_19853_, this.m_142538_()));
            }
        } else {
            this.m_5496_(shootSound, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        }
        this.f_19853_.m_7967_((Entity)throwableEntity);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128365_("TileEntityData", (Tag)this.getOwnerTag());
        tag.m_128365_("InstalledModule", (Tag)this.getDisguiseModule().m_41739_(new CompoundTag()));
        tag.m_128365_("InstalledWhitelist", (Tag)this.getAllowlistModule().m_41739_(new CompoundTag()));
        tag.m_128379_("HasSpeedModule", this.hasSpeedModule());
        tag.m_128405_("SentryMode", ((Integer)this.f_19804_.m_135370_(MODE)).intValue());
        tag.m_128350_("HeadRotation", ((Float)this.f_19804_.m_135370_(HEAD_ROTATION)).floatValue());
        super.m_7380_(tag);
    }

    private CompoundTag getOwnerTag() {
        CompoundTag tag = new CompoundTag();
        Owner owner = (Owner)this.f_19804_.m_135370_(OWNER);
        tag.m_128359_("owner", owner.getName());
        tag.m_128359_("ownerUUID", owner.getUUID());
        return tag;
    }

    public void m_7378_(CompoundTag tag) {
        CompoundTag teTag = tag.m_128469_("TileEntityData");
        String name = teTag.m_128461_("owner");
        String uuid = teTag.m_128461_("ownerUUID");
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(name, uuid));
        this.f_19804_.m_135381_(DISGUISE_MODULE, (Object)tag.m_128469_("InstalledModule"));
        this.f_19804_.m_135381_(ALLOWLIST, (Object)tag.m_128469_("InstalledWhitelist"));
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)tag.m_128471_("HasSpeedModule"));
        this.f_19804_.m_135381_(MODE, (Object)tag.m_128451_("SentryMode"));
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf(tag.m_128457_("HeadRotation")));
        super.m_7378_(tag);
    }

    public Owner getOwner() {
        return (Owner)this.f_19804_.m_135370_(OWNER);
    }

    public void setDisguiseModule(ItemStack module) {
        ArrayList<ItemStack> blocks = ((ModuleItem)module.m_41720_()).getAddons(module.m_41783_());
        if (blocks.size() > 0) {
            ItemStack disguiseStack = (ItemStack)blocks.get(0);
            BlockState state = Block.m_49814_((Item)disguiseStack.m_41720_()).m_49966_();
            if (this.f_19853_.m_8055_(this.m_142538_()).m_60795_()) {
                this.f_19853_.m_46597_(this.m_142538_(), state.m_60808_((BlockGetter)this.f_19853_, this.m_142538_()) == Shapes.m_83144_() ? state : Blocks.f_50016_.m_49966_());
            }
        }
        this.f_19804_.m_135381_(DISGUISE_MODULE, (Object)module.m_41739_(new CompoundTag()));
    }

    public void setAllowlistModule(ItemStack module) {
        this.f_19804_.m_135381_(ALLOWLIST, (Object)module.m_41739_(new CompoundTag()));
    }

    public void setHasSpeedModule(boolean hasSpeedModule) {
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)hasSpeedModule);
    }

    public ItemStack getDisguiseModule() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(DISGUISE_MODULE);
        if (tag == null || tag.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    public ItemStack getAllowlistModule() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(ALLOWLIST);
        if (tag == null || tag.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    public boolean hasSpeedModule() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SPEED_MODULE);
    }

    public SentryMode getMode() {
        int mode = (Integer)this.f_19804_.m_135370_(MODE);
        return mode < 0 || mode >= SentryMode.values().length ? SentryMode.CAMOUFLAGE_HP : SentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean isTargetingAllowedPlayer(LivingEntity potentialTarget) {
        if (potentialTarget != null) {
            List<String> players = ModuleUtils.getPlayersFromModule(this.getAllowlistModule());
            for (String s : players) {
                if (!potentialTarget.m_7755_().m_6111_().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public int getShootingSpeed() {
        return this.hasSpeedModule() ? 5 : 10;
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        return false;
    }

    public void m_6135_() {
    }

    public boolean m_21691_() {
        return false;
    }

    public void m_6043_() {
    }

    public boolean m_6785_(double distanceClosestToPlayer) {
        return false;
    }

    public void m_6123_(Player entity) {
    }

    public void m_6478_(MoverType type, Vec3 vec) {
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_6119_() {
    }

    public Random m_21187_() {
        return notRandom;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static enum SentryMode {
        CAMOUFLAGE_HP(1, 0, 1),
        CAMOUFLAGE_H(1, 1, 3),
        CAMOUFLAGE_P(1, 2, 5),
        AGGRESSIVE_HP(0, 0, 0),
        AGGRESSIVE_H(0, 1, 2),
        AGGRESSIVE_P(0, 2, 4),
        IDLE(-1, -1, 6);

        private final int type;
        private final int attack;
        private final int descriptionKeyIndex;

        private SentryMode(int type, int attack, int descriptionKeyIndex) {
            this.type = type;
            this.attack = attack;
            this.descriptionKeyIndex = descriptionKeyIndex;
        }

        public boolean isAggressive() {
            return this.type == 0;
        }

        public boolean isCamouflage() {
            return this.type == 1;
        }

        public boolean attacksHostile() {
            return this.attack == 0 || this.attack == 1;
        }

        public boolean attacksPlayers() {
            return this.attack == 0 || this.attack == 2;
        }

        public String getModeKey() {
            String key = "messages.securitycraft:sentry.mode";
            return this.isAggressive() ? key + "0" : (this.isCamouflage() ? key + "1" : key + "2");
        }

        public String getTargetKey() {
            String key = "gui.securitycraft:srat.targets";
            return this.attacksHostile() && this.attacksPlayers() ? key + "1" : (this.attacksHostile() ? key + "2" : (this.attacksPlayers() ? key + "3" : ""));
        }

        public String getDescriptionKey() {
            return "messages.securitycraft:sentry.descriptionMode" + this.descriptionKeyIndex;
        }
    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

