/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.ai;

import java.util.Collections;
import java.util.List;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;

public class TargetNearestPlayerOrMobGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private Sentry sentry;

    public TargetNearestPlayerOrMobGoal(Sentry sentry) {
        super((Mob)sentry, LivingEntity.class, true);
        this.sentry = sentry;
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity livingEntity;
        LivingEntity potentialTarget;
        int i;
        List list = this.f_26135_.f_19853_.m_6443_(this.f_26048_, this.m_7255_(this.m_7623_()), e -> !EntityUtils.isInvisible(e));
        if (list.isEmpty()) {
            return false;
        }
        Sentry.SentryMode mode = this.sentry.getMode();
        Collections.sort(list, (e1, e2) -> {
            double distTo2;
            double distTo1 = this.f_26135_.m_20280_((Entity)e1);
            if (distTo1 < (distTo2 = this.f_26135_.m_20280_((Entity)e2))) {
                return -1;
            }
            return distTo1 > distTo2 ? 1 : 0;
        });
        for (i = 0; i < list.size() && ((potentialTarget = (LivingEntity)list.get(i)).m_20147_() || (!mode.attacksPlayers() || !((livingEntity = potentialTarget) instanceof Player) || (player = (Player)livingEntity).m_5833_() || player.m_7500_() || ((Sentry)this.f_26135_).getOwner().isOwner(player) || this.sentry.isTargetingAllowedPlayer(potentialTarget) || EntityUtils.isInvisible(potentialTarget)) && (!mode.attacksHostile() || !this.isSupportedTarget(potentialTarget))); ++i) {
        }
        if (i < list.size() && this.isCloseEnough((Entity)list.get(i))) {
            this.f_26050_ = (LivingEntity)list.get(i);
            this.f_26135_.m_6710_(this.f_26050_);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return (this.isSupportedTarget(this.f_26050_) || this.f_26050_ instanceof Player) && this.isCloseEnough((Entity)this.f_26050_) && this.m_8036_() && !this.sentry.isTargetingAllowedPlayer(this.f_26137_) && super.m_8045_();
    }

    public boolean isCloseEnough(Entity entity) {
        return entity != null && this.f_26135_.m_20280_(entity) <= this.m_7623_() * this.m_7623_();
    }

    public boolean isSupportedTarget(LivingEntity potentialTarget) {
        return potentialTarget.f_20919_ == 0 && (potentialTarget instanceof Monster || potentialTarget instanceof FlyingMob || potentialTarget instanceof Slime || potentialTarget instanceof Shulker || potentialTarget instanceof EnderDragon || SecurityCraftAPI.getRegisteredSentryAttackTargetChecks().stream().anyMatch(check -> check.canAttack((Entity)potentialTarget)));
    }

    protected double m_7623_() {
        return 20.0;
    }
}

