/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class FakeLavaFluid
extends FlowingFluid {
    public Fluid m_5615_() {
        return (Fluid)SCContent.FLOWING_FAKE_LAVA.get();
    }

    public Fluid m_5613_() {
        return (Fluid)SCContent.FAKE_LAVA.get();
    }

    public Item m_6859_() {
        return (Item)SCContent.FAKE_LAVA_BUCKET.get();
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("block/lava_still"), (ResourceLocation)new ResourceLocation("block/lava_flow")).translationKey("block.minecraft.lava").luminosity(15).density(3000).viscosity(6000).temperature(1300).build((Fluid)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7450_(Level world, BlockPos pos, FluidState state, Random random) {
        BlockPos blockpos = pos.m_7494_();
        if (world.m_8055_(blockpos).m_60795_() && !world.m_8055_(blockpos).m_60804_((BlockGetter)world, blockpos)) {
            if (random.nextInt(100) == 0) {
                double x = (float)pos.m_123341_() + random.nextFloat();
                double y = pos.m_123342_() + 1;
                double z = (float)pos.m_123343_() + random.nextFloat();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.0);
                world.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void m_7449_(Level world, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!world.m_46469_().m_46207_(GameRules.f_46131_)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.m_46749_(blockpos = blockpos.m_142082_(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockState = world.m_8055_(blockpos);
                    if (blockState.m_60795_()) {
                        if (!this.isSurroundingBlockFlammable(world, blockpos)) continue;
                        world.m_46597_(blockpos, Blocks.f_50083_.m_49966_());
                        return;
                    }
                    if (!blockState.m_60767_().m_76334_()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.m_142082_(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.m_46749_(blockpos1)) {
                        return;
                    }
                    if (!world.m_46859_(blockpos1.m_7494_()) || !this.getCanBlockBurn(world, blockpos1)) continue;
                    world.m_46597_(blockpos1.m_7494_(), Blocks.f_50083_.m_49966_());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(Level world, BlockPos pos) {
        for (Direction Direction2 : Direction.values()) {
            if (!this.getCanBlockBurn(world, pos.m_142300_(Direction2))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(Level world, BlockPos pos) {
        return !world.m_46749_(pos) ? false : world.m_8055_(pos).m_60767_().m_76335_();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123800_;
    }

    protected void m_7456_(LevelAccessor world, BlockPos pos, BlockState state) {
        this.triggerEffects(world, pos);
    }

    public int m_6719_(LevelReader world) {
        return world.m_6042_().m_63951_() ? 4 : 2;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)((Block)SCContent.FAKE_LAVA_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(FakeLavaFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == SCContent.FAKE_LAVA.get() || fluid == SCContent.FLOWING_FAKE_LAVA.get();
    }

    public int m_6713_(LevelReader world) {
        return world.m_6042_().m_63951_() ? 1 : 2;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter world, BlockPos pos, Fluid fluid, Direction dir) {
        return fluidState.m_76155_(world, pos) >= 0.44444445f && fluid.m_76108_((Tag)FluidTags.f_13131_);
    }

    public int m_6718_(LevelReader world) {
        return world.m_6042_().m_63951_() ? 10 : 30;
    }

    public int m_6886_(Level world, BlockPos pos, FluidState fluidState1, FluidState fluidState2) {
        int i = this.m_6718_((LevelReader)world);
        if (!(fluidState1.m_76178_() || fluidState2.m_76178_() || ((Boolean)fluidState1.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)fluidState2.m_61143_((Property)f_75947_)).booleanValue() || !(fluidState2.m_76155_((BlockGetter)world, pos) > fluidState1.m_76155_((BlockGetter)world, pos)) || world.m_5822_().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    protected void triggerEffects(LevelAccessor world, BlockPos pos) {
        world.m_46796_(1501, pos, 0);
    }

    protected boolean m_6760_() {
        return false;
    }

    protected void m_6364_(LevelAccessor world, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN) {
            FluidState ifluidstate = world.m_6425_(pos);
            if (this.m_76108_((Tag)FluidTags.f_13132_) && ifluidstate.m_76153_((Tag)FluidTags.f_13131_)) {
                if (blockState.m_60734_() instanceof LiquidBlock) {
                    world.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
                }
                this.triggerEffects(world, pos);
                return;
            }
        }
        super.m_6364_(world, pos, blockState, direction, fluidState);
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

