/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.OpenBriefcaseGui;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BriefcaseItem
extends Item
implements DyeableLeatherItem {
    public static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);

    public BriefcaseItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43724_());
    }

    public InteractionResult onItemUse(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ, InteractionHand hand) {
        this.handle(stack, world, player, hand);
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.handle(stack, world, player, hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private void handle(ItemStack stack, Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
                ClientUtils.syncItemNBT(stack);
            }
            if (!stack.m_41783_().m_128441_("passcode")) {
                SecurityCraft.channel.sendToServer((Object)new OpenBriefcaseGui(SCContent.mTypeBriefcaseSetup.getRegistryName(), stack.m_41786_()));
            } else {
                SecurityCraft.channel.sendToServer((Object)new OpenBriefcaseGui(SCContent.mTypeBriefcase.getRegistryName(), stack.m_41786_()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack briefcase, Level world, List<Component> tooltip, TooltipFlag flag) {
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        if (!ownerName.isEmpty()) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:briefcase.owner", ownerName).m_6270_(GRAY_STYLE));
        }
    }

    public static boolean isOwnedBy(ItemStack briefcase, Player player) {
        if (!briefcase.m_41782_()) {
            return true;
        }
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
        return ownerName.isEmpty() || ownerUUID.equals(player.m_142081_().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.m_7755_().getString());
    }

    public static String getOwnerName(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("owner") : "";
    }

    public static String getOwnerUUID(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("ownerUUID") : "";
    }
}

