/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class MineRemoteAccessToolItem
extends Item {
    private static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);

    public MineRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            ClientHandler.displayMRATGui(player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), stack, ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_);
    }

    public InteractionResult onItemUseFirst(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        if (world.m_8055_(pos).m_60734_() instanceof IExplosive) {
            if (!this.isMineAdded(stack, pos)) {
                IOwnable ownable;
                int availSlot = this.getNextAvaliableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof IOwnable && !(ownable = (IOwnable)blockEntity).getOwner().isOwner(player)) {
                    if (world.f_46443_) {
                        ClientHandler.displayMRATGui(stack);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128385_("mine" + availSlot, BlockUtils.posToIntArray(pos));
                if (!world.f_46443_) {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
                }
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                return InteractionResult.SUCCESS;
            }
            this.removeTagFromItemAndUpdate(stack, pos, player);
            PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:mrat.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            if (stack.m_41783_().m_128465_("mine" + i).length > 0) {
                int[] coords = stack.m_41783_().m_128465_("mine" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add((Component)new TextComponent(ChatFormatting.GRAY + "---"));
                    continue;
                }
                list.add((Component)Utils.localize("tooltip.securitycraft:mine", new Object[0]).m_7220_((Component)new TextComponent(" " + i + ": X:" + coords[0] + " Y:" + coords[1] + " Z:" + coords[2])).m_6270_(GRAY_STYLE));
                continue;
            }
            list.add((Component)new TextComponent(ChatFormatting.GRAY + "---"));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, Player player) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("mine" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("mine" + i))[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128385_("mine" + i, new int[]{0, 0, 0});
            if (!player.f_19853_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return;
        }
    }

    private boolean isMineAdded(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.m_41783_().m_128465_("mine" + i).length <= 0 || (coords = stack.m_41783_().m_128465_("mine" + i))[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvaliableSlot(ItemStack stack) {
        for (int i = 1; i <= 6; ++i) {
            if (stack.m_41783_() == null) {
                return 1;
            }
            if (stack.m_41783_().m_128465_("mine" + i).length != 0 && (stack.m_41783_().m_128465_("mine" + i)[0] != 0 || stack.m_41783_().m_128465_("mine" + i)[1] != 0 || stack.m_41783_().m_128465_("mine" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

