/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.inventory.DisguiseModuleMenu;
import net.geforcemods.securitycraft.inventory.ModuleItemContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class ModuleItem
extends Item {
    public static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean nbtCanBeModified;
    private boolean canBeCustomized;
    private int numberOfItemAddons;
    private int numberOfBlockAddons;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean nbtCanBeModified) {
        this(properties, module, nbtCanBeModified, false, 0, 0);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean nbtCanBeModified, boolean canBeCustomized) {
        this(properties, module, nbtCanBeModified, canBeCustomized, 0, 0);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean nbtCanBeModified, boolean canBeCustomized, int itemAddons, int blockAddons) {
        super(properties);
        this.module = module;
        this.nbtCanBeModified = nbtCanBeModified;
        this.canBeCustomized = canBeCustomized;
        this.numberOfItemAddons = itemAddons;
        this.numberOfBlockAddons = blockAddons;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity te = ctx.m_43725_().m_7702_(ctx.m_8083_());
        ItemStack stack = ctx.m_43722_();
        BlockEntity blockEntity = te;
        if (blockEntity instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            ModuleType type = ((ModuleItem)stack.m_41720_()).getModuleType();
            if (inv.getAcceptedModules().contains((Object)type) && !inv.hasModule(type)) {
                inv.insertModule(stack);
                inv.onModuleInserted(stack, type);
                if (!ctx.m_43723_().m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, final InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (world.f_46443_) {
                    ClientHandler.displayEditModuleGui(stack);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!world.f_46443_) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new DisguiseModuleMenu(windowId, inv, new ModuleItemContainer(player.m_21120_(hand)));
                        }

                        public Component m_5446_() {
                            return new TranslatableComponent(ModuleItem.this.m_5524_());
                        }
                    });
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (this.nbtCanBeModified || this.canBeCustomized()) {
            list.add((Component)new TranslatableComponent("tooltip.securitycraft:module.modifiable").m_6270_(GRAY_STYLE));
        } else {
            list.add((Component)new TranslatableComponent("tooltip.securitycraft:module.notModifiable").m_6270_(GRAY_STYLE));
        }
        if (this.canBeCustomized()) {
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons > 0) {
                list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.usage.blocksAndItems", this.numberOfBlockAddons, this.numberOfItemAddons).m_6270_(GRAY_STYLE));
            }
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons == 0) {
                list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.usage.items", this.numberOfItemAddons).m_6270_(GRAY_STYLE));
            }
            if (this.numberOfItemAddons == 0 && this.numberOfBlockAddons > 0) {
                list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.usage.blocks", this.numberOfBlockAddons).m_6270_(GRAY_STYLE));
            }
            if (this.getNumberOfAddons() > 0 && !this.getAddons(stack.m_41783_()).isEmpty()) {
                list.add(TextComponent.f_131282_);
                list.add((Component)Utils.localize("tooltip.securitycraft:module.itemAddons.added", new Object[0]).m_6270_(GRAY_STYLE));
                for (ItemStack addon : this.getAddons(stack.m_41783_())) {
                    list.add((Component)new TextComponent("- ").m_7220_((Component)Utils.localize(addon.m_41778_(), new Object[0])).m_6270_(GRAY_STYLE));
                }
            }
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public int getNumberOfAddons() {
        return this.numberOfItemAddons + this.numberOfBlockAddons;
    }

    public int getNumberOfItemAddons() {
        return this.numberOfItemAddons;
    }

    public int getNumberOfBlockAddons() {
        return this.numberOfBlockAddons;
    }

    public ArrayList<Block> getBlockAddons(CompoundTag tag) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (tag == null) {
            return list;
        }
        ListTag items = tag.m_128437_("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack;
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128451_("Slot");
            if (slot >= this.numberOfBlockAddons || !((stack = ItemStack.m_41712_((CompoundTag)item)).m_41720_() instanceof BlockItem)) continue;
            list.add(Block.m_49814_((Item)stack.m_41720_()));
        }
        return list;
    }

    public ArrayList<ItemStack> getAddons(CompoundTag tag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (tag == null) {
            return list;
        }
        ListTag items = tag.m_128437_("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128451_("Slot");
            if (slot >= this.numberOfBlockAddons) continue;
            list.add(ItemStack.m_41712_((CompoundTag)item));
        }
        return list;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

