/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ReinforcedDoorItem
extends Item {
    public ReinforcedDoorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onItemUse(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43722_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx);
    }

    public InteractionResult onItemUse(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ, UseOnContext ctx) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!block.m_6864_(world.m_8055_(pos), new BlockPlaceContext(ctx))) {
            pos = pos.m_142300_(facing);
        }
        if (player.m_36204_(pos, facing, stack) && BlockUtils.isSideSolid((LevelReader)world, pos.m_7495_(), Direction.UP)) {
            BlockEntity blockEntity;
            boolean flag;
            Direction angleFacing = Direction.m_122364_((double)player.m_146908_());
            int offsetX = angleFacing.m_122429_();
            int offsetZ = angleFacing.m_122431_();
            boolean bl = flag = offsetX < 0 && hitZ < 0.5 || offsetX > 0 && hitZ > 0.5 || offsetZ < 0 && hitX > 0.5 || offsetZ > 0 && hitX < 0.5;
            if (!this.placeDoor(world, pos, angleFacing, (Block)SCContent.REINFORCED_DOOR.get(), flag, ctx)) {
                return InteractionResult.FAIL;
            }
            SoundType soundtype = world.m_8055_(pos).m_60734_().getSoundType(world.m_8055_(pos), (LevelReader)world, pos, (Entity)player);
            world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if ((blockEntity = world.m_7702_(pos)) instanceof OwnableBlockEntity) {
                OwnableBlockEntity te = (OwnableBlockEntity)blockEntity;
                te.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                ((OwnableBlockEntity)world.m_7702_(pos.m_7494_())).setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean placeDoor(Level world, BlockPos pos, Direction facing, Block door, boolean isRightHinge, UseOnContext ctx) {
        boolean isLeftDoor;
        BlockPos posAbove = pos.m_7494_();
        if (!world.m_8055_(posAbove).m_60629_(new BlockPlaceContext(ctx))) {
            return false;
        }
        BlockPos left = pos.m_142300_(facing.m_122427_());
        BlockPos right = pos.m_142300_(facing.m_122428_());
        int rightNormalCubeAmount = (world.m_8055_(right).m_60796_((BlockGetter)world, pos) ? 1 : 0) + (world.m_8055_(right.m_7494_()).m_60796_((BlockGetter)world, pos) ? 1 : 0);
        int leftNormalCubeAmount = (world.m_8055_(left).m_60796_((BlockGetter)world, pos) ? 1 : 0) + (world.m_8055_(left.m_7494_()).m_60796_((BlockGetter)world, pos) ? 1 : 0);
        boolean isRightDoor = world.m_8055_(right).m_60734_() == door || world.m_8055_(right.m_7494_()).m_60734_() == door;
        boolean bl = isLeftDoor = world.m_8055_(left).m_60734_() == door || world.m_8055_(left.m_7494_()).m_60734_() == door;
        if ((!isRightDoor || isLeftDoor) && leftNormalCubeAmount <= rightNormalCubeAmount) {
            if (isLeftDoor && !isRightDoor || leftNormalCubeAmount < rightNormalCubeAmount) {
                isRightHinge = false;
            }
        } else {
            isRightHinge = true;
        }
        boolean isAnyPowered = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, posAbove);
        BlockState state = (BlockState)((BlockState)((BlockState)door.m_49966_().m_61124_((Property)ReinforcedDoorBlock.FACING, (Comparable)facing)).m_61124_(ReinforcedDoorBlock.HINGE, (Comparable)(isRightHinge ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT))).m_61124_((Property)ReinforcedDoorBlock.OPEN, (Comparable)Boolean.valueOf(isAnyPowered));
        world.m_7731_(pos, (BlockState)state.m_61124_(ReinforcedDoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
        world.m_7731_(posAbove, (BlockState)state.m_61124_(ReinforcedDoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        world.m_46672_(pos, door);
        world.m_46672_(posAbove, door);
        return true;
    }
}

