/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Optional;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class TaserItem
extends Item {
    public boolean powered;

    public TaserItem(Item.Properties properties, boolean isPowered) {
        super(properties);
        this.powered = isPowered;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!(group != SecurityCraft.groupSCTechnical && group != CreativeModeTab.f_40754_ || this.powered)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() == SCContent.TASER.get() && newStack.m_41720_() == SCContent.TASER_POWERED.get() || oldStack.m_41720_() == SCContent.TASER_POWERED.get() && newStack.m_41720_() == SCContent.TASER.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41768_()) {
            LivingEntity entity;
            if (player.m_6047_() && (player.m_7500_() || !this.powered)) {
                ItemStack oneRedstone = new ItemStack((ItemLike)Items.f_42451_, 1);
                if (player.m_7500_()) {
                    if (player.m_21120_(hand).m_41720_() == SCContent.TASER.get()) {
                        this.setSlotBasedOnHand(player, hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
                    } else {
                        this.setSlotBasedOnHand(player, hand, new ItemStack((ItemLike)SCContent.TASER.get(), 1));
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (player.m_150109_().m_36063_(oneRedstone)) {
                    int redstoneSlot = player.m_150109_().m_36043_(oneRedstone);
                    ItemStack redstoneStack = player.m_150109_().m_8020_(redstoneSlot);
                    redstoneStack.m_41764_(redstoneStack.m_41613_() - 1);
                    player.m_150109_().m_6836_(redstoneSlot, redstoneStack);
                    this.setSlotBasedOnHand(player, hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            int range = 11;
            Vec3 startVec = player.m_20299_(1.0f);
            Vec3 lookVec = player.m_20252_(1.0f).m_82490_((double)range);
            Vec3 endVec = startVec.m_82549_(lookVec);
            AABB boundingBox = player.m_142469_().m_82369_(lookVec).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityRayTraceResult = TaserItem.rayTraceEntities((Entity)player, startVec, endVec, boundingBox, s -> s instanceof LivingEntity, range * range);
            if (!world.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(player.m_20185_(), player.m_20186_(), player.m_20189_(), SCSounds.TASERFIRED.path, 1.0, "players"));
            }
            if (entityRayTraceResult != null && !(entity = (LivingEntity)entityRayTraceResult.m_82443_()).m_21254_() && entity.m_6469_(CustomDamageSources.TASER, this.powered ? 2.0f : 1.0f)) {
                int strength = this.powered ? 4 : 1;
                int length = this.powered ? 400 : 200;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, length, strength));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, length, strength));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, length, strength));
            }
            if (!player.m_7500_()) {
                if (this.powered) {
                    ItemStack taser = new ItemStack((ItemLike)SCContent.TASER.get(), 1);
                    taser.m_41622_(150, (LivingEntity)player, p -> p.m_21190_(hand));
                    this.setSlotBasedOnHand(player, hand, taser);
                } else {
                    stack.m_41622_(150, (LivingEntity)player, p -> p.m_21190_(hand));
                }
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static EntityHitResult rayTraceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double dist) {
        Level world = shooter.f_19853_;
        double distance = dist;
        Entity rayTracedEntity = null;
        Vec3 hitVec = null;
        for (Entity entity : world.m_6249_(shooter, boundingBox, filter)) {
            Vec3 vector;
            double sqDist;
            AABB boxToCheck = entity.m_142469_().m_82400_((double)entity.m_6143_());
            Optional optional = boxToCheck.m_82371_(startVec, endVec);
            if (boxToCheck.m_82390_(startVec)) {
                if (!(distance >= 0.0)) continue;
                rayTracedEntity = entity;
                hitVec = optional.orElse(startVec);
                distance = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((sqDist = startVec.m_82557_(vector = (Vec3)optional.get())) < distance) && distance != 0.0) continue;
            if (entity.m_20201_() == shooter.m_20201_() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                rayTracedEntity = entity;
                hitVec = vector;
                continue;
            }
            rayTracedEntity = entity;
            hitVec = vector;
            distance = sqDist;
        }
        return rayTracedEntity == null ? null : new EntityHitResult(rayTracedEntity, hitVec);
    }

    private void setSlotBasedOnHand(Player player, InteractionHand hand, ItemStack taser) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_8061_(EquipmentSlot.MAINHAND, taser);
        } else {
            player.m_8061_(EquipmentSlot.OFFHAND, taser);
        }
    }

    public void m_6883_(ItemStack par1ItemStack, Level world, Entity entity, int slotIndex, boolean isSelected) {
        if (!world.f_46443_ && par1ItemStack.m_41773_() >= 1) {
            par1ItemStack.m_41721_(par1ItemStack.m_41773_() - 1);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

