/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.util.TriConsumer;

public class UniversalBlockRemoverItem
extends Item {
    public UniversalBlockRemoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        Player player = ctx.m_43723_();
        if (tile != null && UniversalBlockRemoverItem.isOwnableBlock(block, tile)) {
            if (!((IOwnable)tile).getOwner().isOwner(player)) {
                if (!(block instanceof IBlockMine || tile instanceof DisguisableBlockEntity && !(((BlockItem)((DisguisableBlock)((DisguisableBlockEntity)tile).m_58900_().m_60734_()).getDisguisedStack((BlockGetter)world, pos).m_41720_()).m_40614_() instanceof DisguisableBlock))) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:notOwned", ((IOwnable)tile).getOwner().getName()), ChatFormatting.RED);
                }
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = tile;
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                boolean isChest = tile instanceof KeypadChestBlockEntity;
                for (ItemStack module : inv.getInventory()) {
                    if (isChest) {
                        ((KeypadChestBlockEntity)tile).addOrRemoveModuleFromAttached(module, true);
                    }
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)module);
                }
            }
            if (block == SCContent.LASER_BLOCK.get()) {
                te = (CustomizableBlockEntity)world.m_7702_(pos);
                for (ItemStack module : te.getInventory()) {
                    if (module.m_41619_()) continue;
                    te.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{module, ((ModuleItem)module.m_41720_()).getModuleType()}, te);
                }
                if (!world.f_46443_) {
                    world.m_46961_(pos, true);
                    LaserBlock.destroyAdjacentLasers((LevelAccessor)world, pos);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            } else if (block == SCContent.CAGE_TRAP.get() && ((Boolean)world.m_8055_(pos).m_61143_((Property)CageTrapBlock.DEACTIVATED)).booleanValue()) {
                BlockPos originalPos = pos;
                BlockPos middlePos = originalPos.m_6630_(4);
                if (!world.f_46443_) {
                    new CageTrapBlock.BlockModifier(world, new BlockPos.MutableBlockPos().m_122190_((Vec3i)originalPos), ((IOwnable)tile).getOwner()).loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                        Block b;
                        IOwnable ownable;
                        BlockEntity te = w.m_7702_((BlockPos)p);
                        BlockEntity ownable$temp = te;
                        if (ownable$temp instanceof IOwnable && (ownable = (IOwnable)ownable$temp).getOwner().equals(o) && ((b = w.m_8055_((BlockPos)p).m_60734_()) == SCContent.REINFORCED_IRON_BARS.get() || p.equals((Object)middlePos) && b == SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get())) {
                            w.m_46961_((BlockPos)p, false);
                        }
                    }));
                    world.m_46961_(originalPos, false);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            } else {
                if ((block instanceof ReinforcedDoorBlock || block instanceof SpecialDoorBlock) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                    pos = pos.m_7495_();
                }
                if (block == SCContent.INVENTORY_SCANNER.get() && (te = InventoryScannerBlock.getConnectedInventoryScanner(world, pos)) != null) {
                    te.getInventory().clear();
                }
                if (!world.f_46443_) {
                    world.m_46961_(pos, true);
                    world.m_46747_(pos);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isOwnableBlock(Block block, BlockEntity te) {
        return te instanceof OwnableBlockEntity || te instanceof IOwnable || block instanceof OwnableBlock;
    }
}

