/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.inventory.GenericTEMenu;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class UniversalKeyChangerItem
extends Item {
    public UniversalKeyChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return this.onItemUseFirst(ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43722_(), ctx.m_43724_());
    }

    public InteractionResult onItemUseFirst(Player player, final Level world, final BlockPos pos, Direction side, ItemStack stack, InteractionHand hand) {
        InteractionResult briefcaseResult = this.handleBriefcase(player, hand).m_19089_();
        if (briefcaseResult != InteractionResult.PASS) {
            return briefcaseResult;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IPasswordProtected) {
            if (((IOwnable)te).getOwner().isOwner(player)) {
                if (!world.f_46443_) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new GenericTEMenu(SCContent.mTypeKeyChanger, windowId, world, pos);
                        }

                        public Component m_5446_() {
                            return new TranslatableComponent(UniversalKeyChangerItem.this.m_5524_());
                        }
                    }, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(te instanceof DisguisableBlockEntity) || ((BlockItem)((DisguisableBlock)((DisguisableBlockEntity)te).m_58900_().m_60734_()).getDisguisedStack((BlockGetter)world, pos).m_41720_()).m_40614_() instanceof DisguisableBlock) {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:notOwned", ((IOwnable)world.m_7702_(pos)).getOwner().getName()), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return this.handleBriefcase(player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, InteractionHand hand) {
        ItemStack keyChanger = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.m_21206_();
            if (BriefcaseItem.isOwnedBy(briefcase, player)) {
                if (briefcase.m_41782_() && briefcase.m_41783_().m_128441_("passcode")) {
                    briefcase.m_41783_().m_128473_("passcode");
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), ChatFormatting.GREEN);
                    return InteractionResultHolder.m_19090_((Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResultHolder.m_19096_((Object)keyChanger);
        }
        return InteractionResultHolder.m_19098_((Object)keyChanger);
    }
}

