/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.entity.Sentry;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SentryModel
extends EntityModel<Sentry> {
    public ModelPart base;
    public ModelPart body;
    public ModelPart neck;
    public ModelPart head;
    public ModelPart hair;
    public ModelPart rightEye;
    public ModelPart leftEye;
    public ModelPart nose;
    private final ImmutableList<ModelPart> headPartList;

    public SentryModel(ModelPart modelPart) {
        this.base = modelPart.m_171324_("base");
        this.body = modelPart.m_171324_("body");
        this.neck = modelPart.m_171324_("neck");
        this.head = modelPart.m_171324_("head");
        this.hair = modelPart.m_171324_("hair");
        this.rightEye = modelPart.m_171324_("right_eye");
        this.leftEye = modelPart.m_171324_("left_eye");
        this.nose = modelPart.m_171324_("nose");
        this.headPartList = ImmutableList.of((Object)this.head, (Object)this.neck, (Object)this.rightEye, (Object)this.body, (Object)this.nose, (Object)this.leftEye, (Object)this.hair);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 15.0f, 15.0f), PartPose.m_171419_((float)-7.5f, (float)9.0f, (float)-7.5f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(0.0f, 0.0f, 0.0f, 6.0f, 4.0f, 6.0f), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)-3.0f));
        partDefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171481_(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)-2.0f));
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 5.0f, 6.0f), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)-3.0f));
        partDefinition.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(0.0f, 0.0f, 0.0f, 6.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-3.0f, (float)-5.0f, (float)-3.0f));
        partDefinition.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-2.7f, (float)-3.0f, (float)-3.3f));
        partDefinition.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.7f, (float)-3.0f, (float)-3.3f));
        partDefinition.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171419_((float)-0.5f, (float)-1.0f, (float)-6.9f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void renderBase(PoseStack matrix, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.base.m_104306_(matrix, builder, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_7695_(PoseStack matrix, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.headPartList.forEach(part -> part.m_104301_(matrix, builder, packedLight, packedOverlay));
    }

    public void setupAnim(Sentry entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

