/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PlaySoundAtPos {
    private int x;
    private int y;
    private int z;
    private String sound;
    private double volume;
    private String category;

    public PlaySoundAtPos() {
    }

    public PlaySoundAtPos(int x, int y, int z, String sound, double volume, String cat) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.volume = volume;
        this.category = cat;
    }

    public PlaySoundAtPos(double x, double y, double z, String sound, double volume, String cat) {
        this((int)x, (int)y, (int)z, sound, volume, cat);
    }

    public static void encode(PlaySoundAtPos message, FriendlyByteBuf buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.m_130070_(message.sound);
        buf.writeDouble(message.volume);
        buf.m_130070_(message.category);
    }

    public static PlaySoundAtPos decode(FriendlyByteBuf buf) {
        PlaySoundAtPos message = new PlaySoundAtPos();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.sound = buf.m_130136_(0x1FFFFFFF);
        message.volume = buf.readDouble();
        message.category = buf.m_130136_(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(PlaySoundAtPos message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = ClientHandler.getClientPlayer();
            BlockPos pos = player.m_142538_();
            BlockPos origin = new BlockPos(message.x, message.y, message.z);
            int dist = Math.max(0, Math.min(pos.m_123333_((Vec3i)origin), 20));
            float volume = (float)(message.volume * (double)(1.0f - (float)dist / 20.0f));
            Minecraft.m_91087_().f_91073_.m_5594_(player, origin, new SoundEvent(new ResourceLocation(message.sound)), SoundSource.valueOf((String)message.category.toUpperCase()), volume, 1.0f);
        });
        ctx.get().setPacketHandled(true);
    }
}

