/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class RefreshDisguisableModel {
    private BlockPos pos;
    private boolean insert;
    private ItemStack stack;

    public RefreshDisguisableModel() {
    }

    public RefreshDisguisableModel(BlockPos pos, boolean insert, ItemStack stack) {
        this.pos = pos;
        this.insert = insert;
        this.stack = stack;
    }

    public static void encode(RefreshDisguisableModel message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.insert);
        buf.m_130055_(message.stack);
    }

    public static RefreshDisguisableModel decode(FriendlyByteBuf buf) {
        RefreshDisguisableModel message = new RefreshDisguisableModel();
        message.pos = buf.m_130135_();
        message.insert = buf.readBoolean();
        message.stack = buf.m_130267_();
        return message;
    }

    public static void onMessage(RefreshDisguisableModel message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            DisguisableBlockEntity te = (DisguisableBlockEntity)Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
            if (te != null) {
                if (message.insert) {
                    te.insertModule(message.stack);
                } else {
                    te.removeModule(ModuleType.DISGUISE);
                }
                ClientHandler.refreshModelData(te);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

