/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.inventory.BriefcaseContainer;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class OpenBriefcaseGui {
    private ResourceLocation id;
    private Component name;

    public OpenBriefcaseGui() {
    }

    public OpenBriefcaseGui(ResourceLocation id, Component name) {
        this.id = id;
        this.name = name;
    }

    public static void encode(OpenBriefcaseGui message, FriendlyByteBuf buf) {
        buf.m_130085_(message.id);
        buf.m_130083_(message.name);
    }

    public static OpenBriefcaseGui decode(FriendlyByteBuf buf) {
        OpenBriefcaseGui message = new OpenBriefcaseGui();
        message.id = buf.m_130281_();
        message.name = buf.m_130238_();
        return message;
    }

    public static void onMessage(final OpenBriefcaseGui message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ResourceLocation id = message.id;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos pos = player.m_142538_();
            if (PlayerUtils.isHoldingItem((Player)player, (Item)SCContent.BRIEFCASE.get(), null)) {
                if (id.equals((Object)SCContent.mTypeBriefcaseInventory.getRegistryName())) {
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new BriefcaseMenu(windowId, inv, new BriefcaseContainer(PlayerUtils.getSelectedItemStack(player, (Item)SCContent.BRIEFCASE.get())));
                        }

                        public Component m_5446_() {
                            return message.name;
                        }
                    }, (BlockPos)pos);
                } else if (id.equals((Object)SCContent.mTypeBriefcaseSetup.getRegistryName())) {
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new GenericMenu(SCContent.mTypeBriefcaseSetup, windowId);
                        }

                        public Component m_5446_() {
                            return message.name;
                        }
                    }, (BlockPos)pos);
                } else if (id.equals((Object)SCContent.mTypeBriefcase.getRegistryName())) {
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new GenericMenu(SCContent.mTypeBriefcase, windowId);
                        }

                        public Component m_5446_() {
                            return message.name;
                        }
                    }, (BlockPos)pos);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

